/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.client;

import io.quarkiverse.langchain4j.watsonx.bean.CosError;
import io.quarkiverse.langchain4j.watsonx.exception.COSException;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

public interface COSRestApi {
    @PUT
    @Path(value="{bucketName}/{fileName}")
    public Response createFile(@PathParam(value="bucketName") String var1, @PathParam(value="fileName") String var2, InputStream var3);

    @GET
    @Path(value="{bucketName}/{fileName}")
    public String getFileContent(@PathParam(value="bucketName") String var1, @PathParam(value="fileName") String var2);

    @DELETE
    @Path(value="{bucketName}/{fileName}")
    public Uni<Response> deleteFile(@PathParam(value="bucketName") String var1, @PathParam(value="fileName") String var2);

    @HEAD
    @Path(value="{bucketName}/{fileName}")
    public void getFileMetadata(@PathParam(value="bucketName") String var1, @PathParam(value="fileName") String var2);

    @ClientExceptionMapper
    public static COSException toException(Response response) {
        if ("application/xml".equals(response.getHeaderString("Content-Type"))) {
            CosError error = (CosError)response.readEntity(CosError.class);
            return new COSException(error.getMessage(), error, response.getStatus());
        }
        return new COSException((String)response.readEntity(String.class), response.getStatus());
    }
}

