/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.time.Duration;
import java.util.Map;

public class WatsonxChatRequestParameters
extends DefaultChatRequestParameters {
    private Map<String, Integer> logitBias;
    private Boolean logprobs;
    private Integer topLogprobs;
    private Integer n;
    private Integer seed;
    private String toolChoiceName;
    private Duration timeLimit;

    private WatsonxChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.logitBias = builder.logitBias;
        this.logprobs = builder.logprobs;
        this.topLogprobs = builder.topLogprobs;
        this.n = builder.n;
        this.seed = builder.seed;
        this.toolChoiceName = builder.toolChoiceName;
        this.timeLimit = builder.timeLimit;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public Boolean logprobs() {
        return this.logprobs;
    }

    public Integer topLogprobs() {
        return this.topLogprobs;
    }

    public Integer n() {
        return this.n;
    }

    public Integer seed() {
        return this.seed;
    }

    public String toolChoiceName() {
        return this.toolChoiceName;
    }

    public Duration timeLimit() {
        return this.timeLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatRequestParameters overrideWith(ChatRequestParameters that) {
        return WatsonxChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer n;
        private Integer seed;
        private String toolChoiceName;
        private Duration timeLimit;

        public Builder overrideWith(ChatRequestParameters parameters) {
            parameters = parameters == null ? WatsonxChatRequestParameters.builder().build() : parameters;
            super.overrideWith(parameters);
            if (parameters instanceof WatsonxChatRequestParameters) {
                WatsonxChatRequestParameters watsonxParameters = (WatsonxChatRequestParameters)parameters;
                this.logitBias(Utils.getOrDefault(watsonxParameters.logitBias(), this.logitBias));
                this.logprobs((Boolean)Utils.getOrDefault((Object)watsonxParameters.logprobs(), (Object)this.logprobs));
                this.topLogprobs((Integer)Utils.getOrDefault((Object)watsonxParameters.topLogprobs(), (Object)this.topLogprobs));
                this.n((Integer)Utils.getOrDefault((Object)watsonxParameters.n(), (Object)this.n));
                this.seed((Integer)Utils.getOrDefault((Object)watsonxParameters.seed(), (Object)this.seed));
                this.toolChoiceName((String)Utils.getOrDefault((Object)watsonxParameters.toolChoiceName(), (Object)this.toolChoiceName));
                this.timeLimit((Duration)Utils.getOrDefault((Object)watsonxParameters.timeLimit(), (Object)this.timeLimit));
            }
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder toolChoiceName(String toolChoiceName) {
            this.toolChoiceName = toolChoiceName;
            return this;
        }

        public Builder timeLimit(Duration timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public WatsonxChatRequestParameters build() {
            return new WatsonxChatRequestParameters(this);
        }
    }
}

