/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama.deployment.devservices;

import io.quarkiverse.langchain4j.deployment.devservice.Langchain4jDevServicesEnabled;
import io.quarkiverse.langchain4j.deployment.devservice.OllamaClient;
import io.quarkiverse.langchain4j.deployment.items.DevServicesChatModelRequiredBuildItem;
import io.quarkiverse.langchain4j.deployment.items.DevServicesEmbeddingModelRequiredBuildItem;
import io.quarkiverse.langchain4j.deployment.items.DevServicesOllamaConfigBuildItem;
import io.quarkiverse.langchain4j.ollama.deployment.LangChain4jOllamaOpenAiBuildConfig;
import io.quarkiverse.langchain4j.ollama.deployment.devservices.OllamaContainer;
import io.quarkiverse.langchain4j.ollama.deployment.devservices.OllamaDevServicesBuildConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class OllamaDevServicesProcessor {
    private static final Logger log = Logger.getLogger(OllamaDevServicesProcessor.class);
    public static final String FEATURE = "langchain4j-ollama-dev-service";
    public static final String PROVIDER = "ollama";
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-ollama";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile OllamaDevServicesBuildConfig cfg;
    static volatile boolean first;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={Langchain4jDevServicesEnabled.class})
    public void startOllamaDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, LangChain4jOllamaOpenAiBuildConfig ollamaBuildConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, List<DevServicesChatModelRequiredBuildItem> devServicesChatModels, List<DevServicesEmbeddingModelRequiredBuildItem> devServicesEmbeddingModels, BuildProducer<DevServicesOllamaConfigBuildItem> ollamaDevServicesBuildItemBuildProducer, BuildProducer<DevServicesResultBuildItem> devServicesResultProducer) {
        OllamaDevServicesBuildConfig ollamaDevServicesBuildConfig = ollamaBuildConfig.devservices();
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !ollamaDevServicesBuildConfig.equals(cfg);
            if (!shouldShutdownTheBroker) {
                devServicesResultProducer.produce((BuildItem)devService.toBuildItem());
            }
            this.shutdown();
            cfg = null;
        }
        if (this.isOllamaClientRunning()) {
            log.infof("Not starting Ollama dev services container, as there is already an Ollama instance running on port %d", (Object)11434);
            return;
        }
        LinkedHashSet modelBaseUrlKeys = new LinkedHashSet();
        devServicesChatModels.stream().map(DevServicesChatModelRequiredBuildItem::getBaseUrlProperty).forEach(modelBaseUrlKeys::add);
        devServicesEmbeddingModels.stream().map(DevServicesEmbeddingModelRequiredBuildItem::getBaseUrlProperty).forEach(modelBaseUrlKeys::add);
        if (!modelBaseUrlKeys.isEmpty()) {
            StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Ollama Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
            try {
                devService = this.startOllama(dockerStatusBuildItem, ollamaDevServicesBuildConfig, !devServicesSharedNetworkBuildItem.isEmpty());
                if (devService == null) {
                    compressor.closeAndDumpCaptured();
                } else {
                    compressor.close();
                }
            }
            catch (Throwable t) {
                compressor.closeAndDumpCaptured();
                throw new RuntimeException(t);
            }
            if (devService != null) {
                LinkedHashMap devServiceConfig = new LinkedHashMap(devService.getConfig());
                modelBaseUrlKeys.forEach(baseUrlKey -> devServiceConfig.put(baseUrlKey, (String)devServiceConfig.get("langchain4j-ollama-dev-service.ollama.endpoint")));
                if (devService.isOwner()) {
                    log.info((Object)"Dev Services for Ollama started.");
                    ollamaDevServicesBuildItemBuildProducer.produce((BuildItem)new DevServicesOllamaConfigBuildItem(devServiceConfig));
                }
                if (first) {
                    first = false;
                    Runnable closeTask = () -> {
                        if (devService != null) {
                            this.shutdown();
                            log.info((Object)"Dev Services for Ollama shut down.");
                        }
                        first = true;
                        devService = null;
                        cfg = null;
                    };
                    QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                    ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
                }
                cfg = ollamaDevServicesBuildConfig;
                devServicesResultProducer.produce((BuildItem)new DevServicesResultBuildItem(devService.getName(), devService.getDescription(), devService.getContainerId(), devServiceConfig));
            }
        }
    }

    private boolean isOllamaClientRunning() {
        return OllamaClient.create((OllamaClient.Options)new OllamaClient.Options("localhost", 11434)).isRunning();
    }

    private DevServicesResultBuildItem.RunningDevService startOllama(DockerStatusBuildItem dockerStatusBuildItem, OllamaDevServicesBuildConfig ollamaDevServicesBuildConfig, boolean useSharedNetwork) {
        if (!ollamaDevServicesBuildConfig.enabled()) {
            log.warn((Object)"Not starting dev services for Ollama, as it has been disabled in the config.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Container runtime isn't working, not starting dev services for Ollama.");
            return null;
        }
        OllamaContainer ollama = new OllamaContainer(ollamaDevServicesBuildConfig, useSharedNetwork);
        ollama.start();
        return new DevServicesResultBuildItem.RunningDevService(PROVIDER, ollama.getContainerId(), () -> ((OllamaContainer)ollama).close(), ollama.getExposedConfig());
    }

    private void shutdown() {
        if (devService != null) {
            try {
                log.info((Object)"Dev Services for Ollama shutting down...");
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Ollama server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    static {
        first = true;
    }
}

