/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama.deployment.devservices;

import io.quarkiverse.langchain4j.ollama.deployment.devservices.OllamaDevServicesBuildConfig;
import io.quarkus.devservices.common.ConfigureUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class OllamaContainer
extends org.testcontainers.ollama.OllamaContainer {
    private static final Logger LOG = Logger.getLogger(OllamaContainer.class);
    public static final String CONFIG_OLLAMA_PORT = "langchain4j-ollama-dev-service.ollama.port";
    public static final String CONFIG_OLLAMA_HTTP_SERVER = "langchain4j-ollama-dev-service.ollama.host";
    public static final String CONFIG_OLLAMA_ENDPOINT = "langchain4j-ollama-dev-service.ollama.endpoint";
    public static final int DEFAULT_OLLAMA_PORT = 11434;
    private static final String DEFAULT_OLLAMA_DIRECTORY = "/root/.ollama";
    private final boolean useSharedNetwork;
    private String hostName;

    OllamaContainer(OllamaDevServicesBuildConfig config, boolean useSharedNetwork) {
        super(DockerImageName.parse((String)config.imageName()).asCompatibleSubstituteFor("ollama/ollama"));
        this.useSharedNetwork = useSharedNetwork;
        ((org.testcontainers.ollama.OllamaContainer)super.withLabel("quarkus-dev-service-ollama", "ollama")).withStartupTimeout(Duration.ofMinutes(1L));
        Path localOllamaDir = (System.getenv("OLLAMA_MODELS") != null ? Paths.get(System.getenv("OLLAMA_MODELS"), new String[0]) : Paths.get(System.getProperty("user.home"), ".ollama")).normalize();
        OllamaContainer.createLocalOllamaDirIfNeeded(localOllamaDir);
        if (Files.isDirectory(localOllamaDir, new LinkOption[0])) {
            try {
                super.withFileSystemBind(localOllamaDir.toRealPath(new LinkOption[0]).toString(), DEFAULT_OLLAMA_DIRECTORY, BindMode.READ_WRITE);
            }
            catch (IOException e) {
                LOG.warnf("Not able to bind Ollama directory %s to %s because of %s. This means that downloaded models may not be shared with the Ollama client.", (Object)localOllamaDir.toString(), (Object)DEFAULT_OLLAMA_DIRECTORY, (Object)e.getMessage());
            }
        }
    }

    private static void createLocalOllamaDirIfNeeded(Path localOllamaDir) {
        if (!Files.isDirectory(localOllamaDir, new LinkOption[0])) {
            try {
                Files.createDirectories(localOllamaDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.warnf("Not able to create Ollama directory %s because of %s", (Object)localOllamaDir.toString(), (Object)e.getMessage());
            }
        }
    }

    protected void configure() {
        super.configure();
        if (this.useSharedNetwork) {
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"ollama");
        }
    }

    public Map<String, String> getExposedConfig() {
        String host = this.getHost();
        int port = this.getPort();
        HashMap<String, String> exposed = new HashMap<String, String>(3);
        exposed.put(CONFIG_OLLAMA_PORT, Objects.toString(port));
        exposed.put(CONFIG_OLLAMA_HTTP_SERVER, host);
        exposed.put(CONFIG_OLLAMA_ENDPOINT, this.getEndpoint());
        exposed.putAll(this.getEnvMap());
        return exposed;
    }

    public int getPort() {
        return this.getMappedPort(11434);
    }

    public String getHost() {
        return this.hostName != null && !this.hostName.isEmpty() ? this.hostName : super.getHost();
    }
}

