/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.oidc.mcp.runtime;

import io.quarkiverse.langchain4j.mcp.auth.McpClientAuthProvider;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.credential.TokenCredential;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

public class OidcMcpAuthProvider
implements McpClientAuthProvider {
    private static final Logger log = Logger.getLogger(OidcMcpAuthProvider.class);

    public String getAuthorization(McpClientAuthProvider.Input input) {
        ManagedContext managedContext = Arc.container().requestContext();
        if (managedContext.isActive()) {
            InjectableInstance tokenCredential = Arc.container().select(TokenCredential.class, new Annotation[0]);
            if (tokenCredential.isResolvable()) {
                log.debug((Object)"Providing the current access token as a bearer access token");
                return "Bearer " + ((TokenCredential)tokenCredential.get()).getToken();
            }
            log.debug((Object)"Access token is not available");
        } else {
            log.debug((Object)"Access token can not be detected because the request context is not active");
        }
        return null;
    }
}

