/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.memorystore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.quarkus.redis.datasource.value.ValueCommands;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;

public class RedisChatMemoryStore
implements ChatMemoryStore {
    private static final TypeReference<List<ChatMessage>> MESSAGE_LIST_TYPE = new TypeReference<List<ChatMessage>>(){};
    private final ValueCommands<String, byte[]> valueCommands;
    private final KeyCommands<String> keyCommands;

    public RedisChatMemoryStore(RedisDataSource redisDataSource) {
        this.valueCommands = redisDataSource.value((TypeReference)new TypeReference<byte[]>(){});
        this.keyCommands = redisDataSource.key(String.class);
    }

    public void deleteMessages(Object memoryId) {
        this.keyCommands.del((Object[])new String[]{memoryId.toString()});
    }

    public List<ChatMessage> getMessages(Object memoryId) {
        byte[] bytes = (byte[])this.valueCommands.get((Object)memoryId.toString());
        if (bytes == null) {
            return Collections.emptyList();
        }
        try {
            return (List)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.readValue(bytes, MESSAGE_LIST_TYPE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void updateMessages(Object memoryId, List<ChatMessage> messages) {
        try {
            this.valueCommands.set((Object)memoryId.toString(), (Object)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.writeValueAsBytes(messages));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

