/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.memorystore.redis.deployment;

import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import io.quarkiverse.langchain4j.memorystore.RedisChatMemoryStore;
import io.quarkiverse.langchain4j.memorystore.redis.deployment.RedisMemoryStoreBuildTimeConfig;
import io.quarkiverse.langchain4j.memorystore.redis.runtime.RedisMemoryStoreRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.deployment.client.RequestedRedisClientBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class RedisMemoryStoreProcessor {
    public static final DotName REDIS_CHAT_MEMORY_STORE = DotName.createSimple(RedisChatMemoryStore.class);
    private static final String FEATURE = "langchain4j-memory-store-redis";

    RedisMemoryStoreProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public RequestedRedisClientBuildItem requestRedisClient(RedisMemoryStoreBuildTimeConfig config) {
        return new RequestedRedisClientBuildItem(config.clientName().orElse("<default>"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void createMemoryStoreBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<SyntheticBeanBuildItem> beanProducer, RedisMemoryStoreRecorder recorder, RedisMemoryStoreBuildTimeConfig buildTimeConfig) {
        String clientName = buildTimeConfig.clientName().orElse(null);
        AnnotationInstance redisClientQualifier = clientName == null ? AnnotationInstance.builder(Default.class).build() : AnnotationInstance.builder(RedisClientName.class).add("value", clientName).build();
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)REDIS_CHAT_MEMORY_STORE).types(new Type[]{ClassType.create(ChatMemoryStore.class)})).setRuntimeInit().scope(ApplicationScoped.class)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(RedisDataSource.class)), new AnnotationInstance[]{redisClientQualifier})).createWith(recorder.chatMemoryStoreFunction(clientName)).done());
    }
}

