/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime.http;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;

class McpHttpClientLogger
implements ClientLogger {
    private static final Logger log = Logger.getLogger(McpHttpClientLogger.class);
    private final boolean logRequests;
    private final boolean logResponses;

    public McpHttpClientLogger(boolean logRequests, boolean logResponses) {
        this.logRequests = logRequests;
        this.logResponses = logResponses;
    }

    public void setBodySize(int bodySize) {
    }

    public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
        if (this.logRequests && log.isInfoEnabled()) {
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }
    }

    public void logResponse(final HttpClientResponse response, boolean redirect) {
        if (this.logResponses && log.isInfoEnabled()) {
            response.bodyHandler((Handler)new Handler<Buffer>(this){
                final /* synthetic */ McpHttpClientLogger this$0;
                {
                    this.this$0 = this$0;
                }

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.this$0.inOneLine(response.headers()), (Object)this.this$0.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }
    }

    private String inOneLine(MultiMap headers) {
        return StreamSupport.stream(headers.spliterator(), false).map(header -> {
            String headerKey = (String)header.getKey();
            String headerValue = (String)header.getValue();
            return "[%s: %s]".formatted(headerKey, headerValue);
        }).collect(Collectors.joining(", "));
    }

    private String bodyToString(Buffer body) {
        return body != null ? body.toString() : "";
    }
}

