/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mcp.runtime;

import dev.langchain4j.mcp.client.DefaultMcpClient;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.mcp.client.McpRoot;
import dev.langchain4j.mcp.client.logging.McpLogMessageHandler;
import dev.langchain4j.mcp.client.transport.McpTransport;
import dev.langchain4j.mcp.client.transport.stdio.StdioMcpTransport;
import dev.langchain4j.service.tool.ToolProvider;
import io.opentelemetry.api.trace.Tracer;
import io.quarkiverse.langchain4j.mcp.runtime.McpClientName;
import io.quarkiverse.langchain4j.mcp.runtime.QuarkusDefaultMcpLogHandler;
import io.quarkiverse.langchain4j.mcp.runtime.QuarkusMcpToolProvider;
import io.quarkiverse.langchain4j.mcp.runtime.config.LocalLaunchParams;
import io.quarkiverse.langchain4j.mcp.runtime.config.McpClientRuntimeConfig;
import io.quarkiverse.langchain4j.mcp.runtime.config.McpRuntimeConfiguration;
import io.quarkiverse.langchain4j.mcp.runtime.config.McpTransportType;
import io.quarkiverse.langchain4j.mcp.runtime.http.QuarkusHttpMcpTransport;
import io.quarkiverse.langchain4j.mcp.runtime.http.QuarkusStreamableHttpMcpTransport;
import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class McpRecorder {
    private static final TypeLiteral<Instance<Tracer>> TRACER_TYPE_LITERAL = new TypeLiteral<Instance<Tracer>>(){};
    public static Map<String, LocalLaunchParams> claudeConfigContents = Collections.emptyMap();
    private final RuntimeValue<McpRuntimeConfiguration> mcpRuntimeConfiguration;
    private Vertx vertx;

    public McpRecorder(RuntimeValue<McpRuntimeConfiguration> mcpRuntimeConfiguration) {
        this.mcpRuntimeConfiguration = mcpRuntimeConfiguration;
    }

    public void claudeConfigContents(Map<String, LocalLaunchParams> contents) {
        claudeConfigContents = contents;
    }

    public Supplier<McpClient> mcpClientSupplier(final String key, final McpTransportType mcpTransportType, final ShutdownContext shutdown, final Supplier<Vertx> vertx) {
        return new Supplier<McpClient>(){
            final /* synthetic */ McpRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public McpClient get() {
                McpClientRuntimeConfig runtimeConfig = ((McpRuntimeConfiguration)this.this$0.mcpRuntimeConfiguration.getValue()).clients().get(key);
                ArrayList<McpRoot> initialRoots = new ArrayList<McpRoot>();
                if (runtimeConfig.roots().isPresent()) {
                    for (String kvPair : runtimeConfig.roots().get()) {
                        String[] split = kvPair.split("=");
                        initialRoots.add(new McpRoot(split[0], split[1]));
                    }
                }
                Optional<TlsConfiguration> tlsConfiguration = this.this$0.resolveTlsConfiguration(runtimeConfig);
                StdioMcpTransport transport = switch (mcpTransportType) {
                    default -> throw new IncompatibleClassChangeError();
                    case McpTransportType.STDIO -> {
                        List<String> command = runtimeConfig.command().orElseThrow(() -> new ConfigurationException("MCP client configuration named " + key + " is missing the 'command' property"));
                        yield new StdioMcpTransport.Builder().command(command).logEvents(runtimeConfig.logResponses().orElse(false).booleanValue()).environment(runtimeConfig.environment()).build();
                    }
                    case McpTransportType.HTTP -> new QuarkusHttpMcpTransport.Builder().sseUrl(runtimeConfig.url().orElseThrow(() -> new ConfigurationException("MCP client configuration named " + key + " is missing the 'url' property"))).logRequests(runtimeConfig.logRequests().orElse(false)).logResponses(runtimeConfig.logResponses().orElse(false)).tlsConfiguration(tlsConfiguration.orElse(null)).mcpClientName(key).timeout(runtimeConfig.toolExecutionTimeout()).build();
                    case McpTransportType.STREAMABLE_HTTP -> {
                        HttpClientOptions httpClientOptions = new HttpClientOptions();
                        tlsConfiguration.ifPresent(tls -> TlsConfigUtils.configure((HttpClientOptions)httpClientOptions, (TlsConfiguration)tls));
                        yield new QuarkusStreamableHttpMcpTransport.Builder().url(runtimeConfig.url().orElseThrow(() -> new ConfigurationException("MCP client configuration named " + key + " is missing the 'url' property"))).logRequests(runtimeConfig.logRequests().orElse(false)).logResponses(runtimeConfig.logResponses().orElse(false)).httpClient(((Vertx)vertx.get()).createHttpClient(httpClientOptions)).mcpClientName(key).timeout(runtimeConfig.toolExecutionTimeout()).build();
                    }
                };
                DefaultMcpClient client = new DefaultMcpClient.Builder().key(key).transport((McpTransport)transport).toolExecutionTimeout(runtimeConfig.toolExecutionTimeout()).resourcesTimeout(runtimeConfig.resourcesTimeout()).pingTimeout(runtimeConfig.pingTimeout()).logHandler((McpLogMessageHandler)new QuarkusDefaultMcpLogHandler(key)).roots(initialRoots).cacheToolList(runtimeConfig.cacheToolList().orElse(true).booleanValue()).build();
                shutdown.addShutdownTask(() -> ((DefaultMcpClient)client).close());
                return client;
            }
        };
    }

    public Function<SyntheticCreationalContext<ToolProvider>, ToolProvider> toolProviderFunction(final Set<String> mcpClientNames) {
        return new Function<SyntheticCreationalContext<ToolProvider>, ToolProvider>(this){
            final /* synthetic */ McpRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ToolProvider apply(SyntheticCreationalContext<ToolProvider> context) {
                ArrayList<McpClient> clients = new ArrayList<McpClient>();
                for (String mcpClientName : mcpClientNames) {
                    McpClientName.Literal qualifier = McpClientName.Literal.of(mcpClientName);
                    clients.add((McpClient)context.getInjectedReference(McpClient.class, new Annotation[]{qualifier}));
                }
                boolean exposeResourcesAsTools = ((McpRuntimeConfiguration)this.this$0.mcpRuntimeConfiguration.getValue()).exposeResourcesAsTools().orElse(false);
                return new QuarkusMcpToolProvider(clients, (Instance<Tracer>)((Instance)context.getInjectedReference(TRACER_TYPE_LITERAL, new Annotation[0])), exposeResourcesAsTools);
            }
        };
    }

    private Optional<TlsConfiguration> resolveTlsConfiguration(McpClientRuntimeConfig runtimeConfig) {
        if (Arc.container() != null) {
            TlsConfigurationRegistry tlsConfigurationRegistry = (TlsConfigurationRegistry)Arc.container().select(TlsConfigurationRegistry.class, new Annotation[0]).orNull();
            if (tlsConfigurationRegistry != null) {
                if (runtimeConfig.tlsConfigurationName().isPresent()) {
                    Optional namedConfig = TlsConfiguration.from((TlsConfigurationRegistry)tlsConfigurationRegistry, runtimeConfig.tlsConfigurationName());
                    if (namedConfig.isEmpty()) {
                        throw new ConfigurationException("TLS configuration '" + runtimeConfig.tlsConfigurationName().get() + "' was specified, but it does not exist.");
                    }
                    return namedConfig;
                }
                return tlsConfigurationRegistry.getDefault();
            }
            if (runtimeConfig.tlsConfigurationName().isPresent()) {
                throw new ConfigurationException("TLS configuration '" + runtimeConfig.tlsConfigurationName().get() + "' was specified, but no TLS configuration registry could be found.");
            }
        }
        return Optional.empty();
    }
}

