/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.listeners;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import io.opentelemetry.api.trace.Span;
import io.quarkiverse.langchain4j.runtime.listeners.ChatModelSpanContributor;
import jakarta.inject.Singleton;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class PromptTextSpanContributor
implements ChatModelSpanContributor {
    private final boolean includePrompt;

    public PromptTextSpanContributor(@ConfigProperty(name="quarkus.langchain4j.tracing.include-prompt") boolean includePrompt) {
        this.includePrompt = includePrompt;
    }

    @Override
    public void onRequest(ChatModelRequestContext requestContext, Span currentSpan) {
        if (!this.includePrompt) {
            return;
        }
        currentSpan.setAttribute("gen_ai.prompt", requestContext.chatRequest().messages().stream().map(ChatMessage::text).collect(Collectors.joining("\n")));
    }
}

