/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.listeners;

import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import io.opentelemetry.api.trace.Span;
import io.quarkiverse.langchain4j.runtime.listeners.ChatModelSpanContributor;
import jakarta.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class CompletionTextSpanContributor
implements ChatModelSpanContributor {
    private final boolean includeCompletion;

    public CompletionTextSpanContributor(@ConfigProperty(name="quarkus.langchain4j.tracing.include-completion") boolean includeCompletion) {
        this.includeCompletion = includeCompletion;
    }

    @Override
    public void onResponse(ChatModelResponseContext requestContext, Span currentSpan) {
        if (!this.includeCompletion) {
            return;
        }
        currentSpan.setAttribute("gen_ai.completion", requestContext.chatResponse().aiMessage().text());
    }
}

