/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.guardrails;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;

@ApplicationScoped
public class JsonGuardrailsUtils {
    @Inject
    ObjectMapper objectMapper;

    private JsonGuardrailsUtils() {
    }

    public String trimNonJson(String llmResponse) {
        int jsonMapStart = llmResponse.indexOf(123);
        int jsonListStart = llmResponse.indexOf(91);
        if (jsonMapStart < 0 && jsonListStart < 0) {
            return null;
        }
        boolean isJsonMap = jsonMapStart >= 0 && (jsonMapStart < jsonListStart || jsonListStart < 0);
        int jsonStart = isJsonMap ? jsonMapStart : jsonListStart;
        int jsonEnd = isJsonMap ? llmResponse.lastIndexOf(125) : llmResponse.lastIndexOf(93);
        return jsonEnd >= 0 && jsonStart < jsonEnd ? llmResponse.substring(jsonStart, jsonEnd + 1) : null;
    }

    public <T> T deserialize(String json, Class<T> expectedOutputClass) {
        try {
            return (T)this.objectMapper.readValue(json, expectedOutputClass);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public <T> T deserialize(String json, TypeReference<T> expectedOutputType) {
        try {
            return (T)this.objectMapper.readValue(json, expectedOutputType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

