/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.scoring.ScoringModel;
import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.RequestChatModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestImageModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestModerationModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.config.LangChain4jBuildConfig;
import io.quarkiverse.langchain4j.deployment.items.AutoCreateEmbeddingModelBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ImageModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ImplicitlyUserConfiguredChatProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.InProcessEmbeddingBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ModerationModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ProviderHolder;
import io.quarkiverse.langchain4j.deployment.items.ScoringModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedImageModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedModerationModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedScoringModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.LangChain4jRecorder;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class BeansProcessor {
    private static final String FEATURE = "langchain4j";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> producer) {
        producer.produce((BuildItem)new IndexDependencyBuildItem("dev.langchain4j", "langchain4j-core"));
    }

    @BuildStep
    public void handleProviders(BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, List<ChatModelProviderCandidateBuildItem> chatCandidateItems, List<ScoringModelProviderCandidateBuildItem> scoringCandidateItems, List<EmbeddingModelProviderCandidateBuildItem> embeddingCandidateItems, List<ModerationModelProviderCandidateBuildItem> moderationCandidateItems, List<ImageModelProviderCandidateBuildItem> imageCandidateItems, List<RequestChatModelBeanBuildItem> requestChatModelBeanItems, List<RequestModerationModelBeanBuildItem> requestModerationModelBeanBuildItems, List<RequestImageModelBeanBuildItem> requestImageModelBeanBuildItems, List<ImplicitlyUserConfiguredChatProviderBuildItem> userConfiguredProviderBuildItems, LangChain4jBuildConfig buildConfig, Optional<AutoCreateEmbeddingModelBuildItem> autoCreateEmbeddingModelBuildItem, BuildProducer<SelectedChatModelProviderBuildItem> selectedChatProducer, BuildProducer<SelectedScoringModelProviderBuildItem> selectedScoringProducer, BuildProducer<SelectedEmbeddingModelCandidateBuildItem> selectedEmbeddingProducer, BuildProducer<SelectedModerationModelProviderBuildItem> selectedModerationProducer, BuildProducer<SelectedImageModelProviderBuildItem> selectedImageProducer, List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems) {
        String provider;
        Iterator userSelectedProvider2;
        String provider2;
        Optional<String> userSelectedProvider;
        Object configNamespace;
        HashSet<String> requestedChatModels = new HashSet<String>();
        HashSet<String> requestedStreamingChatModels = new HashSet<String>();
        HashSet<String> requestScoringModels = new HashSet<String>();
        HashSet<String> requestEmbeddingModels = new HashSet<String>();
        HashSet<String> requestedModerationModels = new HashSet<String>();
        HashSet<String> requestedImageModels = new HashSet<String>();
        HashSet<String> tokenCountEstimators = new HashSet<String>();
        boolean defaultChatModelRequested = false;
        boolean defaultScoringModelRequested = false;
        boolean defaultEmbeddingModelRequested = false;
        boolean defaultModerationModelRequested = false;
        boolean defaultImageModelRequested = false;
        String chatModelConfigNamespace = "chat-model";
        String embeddingModelConfigNamespace = "embedding-model";
        String scoringModelConfigNamespace = "scoring-model";
        String moderationModelConfigNamespace = "moderation-model";
        String imageModelConfigNamespace = "image-model";
        String dot = ".";
        String chatModelBeanType = "ChatLanguageModel or StreamingChatLanguageModel";
        String embeddingModelBeanType = "EmbeddingModel";
        String scoringModelBeanType = "ScoringModel";
        String moderationModelBeanType = "ModerationModel";
        String imageModelBeanType = "ImageModel";
        for (InjectionPointInfo injectionPointInfo : beanDiscoveryFinished.getInjectionPoints()) {
            DotName requiredName = injectionPointInfo.getRequiredType().name();
            String modelName = this.determineModelName(injectionPointInfo);
            if (modelName == null) continue;
            if (LangChain4jDotNames.CHAT_MODEL.equals((Object)requiredName)) {
                requestedChatModels.add(modelName);
                continue;
            }
            if (LangChain4jDotNames.STREAMING_CHAT_MODEL.equals((Object)requiredName)) {
                requestedStreamingChatModels.add(modelName);
                continue;
            }
            if (LangChain4jDotNames.SCORING_MODEL.equals((Object)requiredName)) {
                requestScoringModels.add(modelName);
                continue;
            }
            if (LangChain4jDotNames.EMBEDDING_MODEL.equals((Object)requiredName)) {
                requestEmbeddingModels.add(modelName);
                continue;
            }
            if (LangChain4jDotNames.MODERATION_MODEL.equals((Object)requiredName)) {
                requestedModerationModels.add(modelName);
                continue;
            }
            if (LangChain4jDotNames.IMAGE_MODEL.equals((Object)requiredName)) {
                requestedImageModels.add(modelName);
                continue;
            }
            if (!LangChain4jDotNames.TOKEN_COUNT_ESTIMATOR.equals((Object)requiredName)) continue;
            tokenCountEstimators.add(modelName);
        }
        for (RequestChatModelBeanBuildItem requestChatModelBeanBuildItem : requestChatModelBeanItems) {
            requestedChatModels.add(requestChatModelBeanBuildItem.getConfigName());
        }
        for (RequestModerationModelBeanBuildItem requestModerationModelBeanBuildItem : requestModerationModelBeanBuildItems) {
            requestedModerationModels.add(requestModerationModelBeanBuildItem.getConfigName());
        }
        for (RequestImageModelBeanBuildItem requestImageModelBeanBuildItem : requestImageModelBeanBuildItems) {
            requestedImageModels.add(requestImageModelBeanBuildItem.getConfigName());
        }
        if (!(requestedChatModels.isEmpty() && requestedStreamingChatModels.isEmpty() && tokenCountEstimators.isEmpty())) {
            Iterator allChatModelNames = new HashSet<String>(requestedChatModels);
            allChatModelNames.addAll(requestedStreamingChatModels);
            allChatModelNames.addAll(tokenCountEstimators);
            Iterator iterator = allChatModelNames.iterator();
            while (iterator.hasNext()) {
                String provider3;
                List<ImplicitlyUserConfiguredChatProviderBuildItem> matchingImplicitlyUserConfiguredChatProviders;
                String configNamespace2;
                Optional<String> userSelectedProvider3;
                String modelName = (String)iterator.next();
                if (NamedConfigUtil.isDefault((String)modelName)) {
                    Optional<String> userSelectedProvider4 = buildConfig.defaultConfig().chatModel().provider();
                    String configNamespace22 = "chat-model";
                    defaultChatModelRequested = true;
                } else {
                    userSelectedProvider3 = buildConfig.namedConfig().containsKey(modelName) ? buildConfig.namedConfig().get(modelName).chatModel().provider() : Optional.empty();
                    configNamespace2 = modelName + ".chat-model";
                }
                if (userSelectedProvider3.isEmpty() && !NamedConfigUtil.isDefault((String)modelName) && (matchingImplicitlyUserConfiguredChatProviders = userConfiguredProviderBuildItems.stream().filter(bi -> bi.getConfigName().equals(modelName)).toList()).size() == 1) {
                    userSelectedProvider3 = Optional.of(matchingImplicitlyUserConfiguredChatProviders.get(0).getProvider());
                }
                if ((provider3 = this.selectProvider(chatCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ChatLanguageModel.class), userSelectedProvider3, "ChatLanguageModel or StreamingChatLanguageModel", configNamespace2)) == null) continue;
                selectedChatProducer.produce((BuildItem)new SelectedChatModelProviderBuildItem(provider3, modelName));
            }
        }
        for (String string : requestScoringModels) {
            String provider22;
            if (NamedConfigUtil.isDefault((String)string)) {
                Optional<String> userSelectedProvider3 = buildConfig.defaultConfig().scoringModel().provider();
                configNamespace = "scoring-model";
                defaultScoringModelRequested = true;
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).scoringModel().provider() : Optional.empty();
                configNamespace = string + ".scoring-model";
            }
            if ((provider22 = this.selectProvider(scoringCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ScoringModel.class), userSelectedProvider, "ScoringModel", (String)configNamespace)) == null) continue;
            selectedScoringProducer.produce((BuildItem)new SelectedScoringModelProviderBuildItem(provider22, string));
        }
        for (String string : requestEmbeddingModels) {
            if (NamedConfigUtil.isDefault((String)string)) {
                userSelectedProvider = buildConfig.defaultConfig().embeddingModel().provider();
                configNamespace = "embedding-model";
                defaultEmbeddingModelRequested = true;
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).embeddingModel().provider() : Optional.empty();
                configNamespace = string + ".embedding-model";
            }
            if ((provider2 = this.selectEmbeddingModelProvider(inProcessEmbeddingBuildItems, embeddingCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(EmbeddingModel.class), userSelectedProvider, "EmbeddingModel", (String)configNamespace)) == null) continue;
            selectedEmbeddingProducer.produce((BuildItem)new SelectedEmbeddingModelCandidateBuildItem(provider2, string));
        }
        if (requestEmbeddingModels.isEmpty() && autoCreateEmbeddingModelBuildItem.isPresent() && ((Optional)((Object)(userSelectedProvider2 = buildConfig.defaultConfig().embeddingModel().provider()))).isEmpty()) {
            String string = this.selectEmbeddingModelProvider(inProcessEmbeddingBuildItems, (List)embeddingCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(EmbeddingModel.class), (Optional<String>)((Object)userSelectedProvider2), "EmbeddingModel", "embedding-model");
            selectedEmbeddingProducer.produce((BuildItem)new SelectedEmbeddingModelCandidateBuildItem(string, "<default>"));
        }
        for (String string : requestedModerationModels) {
            if (NamedConfigUtil.isDefault((String)string)) {
                userSelectedProvider = buildConfig.defaultConfig().moderationModel().provider();
                configNamespace = "moderation-model";
                defaultModerationModelRequested = true;
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).moderationModel().provider() : Optional.empty();
                configNamespace = string + ".moderation-model";
            }
            if ((provider2 = this.selectProvider(moderationCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ModerationModel.class), userSelectedProvider, "ModerationModel", (String)configNamespace)) == null) continue;
            selectedModerationProducer.produce((BuildItem)new SelectedModerationModelProviderBuildItem(provider2, string));
        }
        for (String string : requestedImageModels) {
            if (NamedConfigUtil.isDefault((String)string)) {
                userSelectedProvider = buildConfig.defaultConfig().imageModel().provider();
                configNamespace = "image-model";
                defaultImageModelRequested = true;
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).imageModel().provider() : Optional.empty();
                configNamespace = string + ".image-model";
            }
            if ((provider2 = this.selectProvider(imageCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ImageModel.class), userSelectedProvider, "ImageModel", (String)configNamespace)) == null) continue;
            selectedImageProducer.produce((BuildItem)new SelectedImageModelProviderBuildItem(provider2, string));
        }
        LangChain4jBuildConfig.BaseConfig defaultConfig = buildConfig.defaultConfig();
        if (!defaultChatModelRequested && !defaultConfig.chatModel().provider().isEmpty()) {
            Optional<String> optional = defaultConfig.chatModel().provider();
            provider = this.selectProvider(chatCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ChatLanguageModel.class), optional, "ChatLanguageModel or StreamingChatLanguageModel", "chat-model");
            if (provider != null) {
                selectedChatProducer.produce((BuildItem)new SelectedChatModelProviderBuildItem(provider, "<default>"));
            }
        }
        if (!defaultEmbeddingModelRequested && !defaultConfig.embeddingModel().provider().isEmpty()) {
            Optional<String> optional = defaultConfig.embeddingModel().provider();
            provider = this.selectEmbeddingModelProvider(inProcessEmbeddingBuildItems, embeddingCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(EmbeddingModel.class), optional, "EmbeddingModel", "embedding-model");
            if (provider != null) {
                selectedEmbeddingProducer.produce((BuildItem)new SelectedEmbeddingModelCandidateBuildItem(provider, "<default>"));
            }
        }
        if (!defaultScoringModelRequested && !defaultConfig.scoringModel().provider().isEmpty()) {
            Optional<String> optional = defaultConfig.scoringModel().provider();
            provider = this.selectProvider(scoringCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ScoringModel.class), optional, "ScoringModel", "scoring-model");
            if (provider != null) {
                selectedScoringProducer.produce((BuildItem)new SelectedScoringModelProviderBuildItem(provider, "<default>"));
            }
        }
        if (!defaultModerationModelRequested && !defaultConfig.moderationModel().provider().isEmpty()) {
            Optional<String> optional = defaultConfig.moderationModel().provider();
            provider = this.selectProvider(moderationCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ModerationModel.class), optional, "ModerationModel", "moderation-model");
            if (provider != null) {
                selectedModerationProducer.produce((BuildItem)new SelectedModerationModelProviderBuildItem(provider, "<default>"));
            }
        }
        if (!defaultImageModelRequested && !defaultConfig.imageModel().provider().isEmpty()) {
            Optional<String> optional = defaultConfig.imageModel().provider();
            provider = this.selectProvider(imageCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ImageModel.class), optional, "ImageModel", "image-model");
            if (provider != null) {
                selectedImageProducer.produce((BuildItem)new SelectedImageModelProviderBuildItem(provider, "<default>"));
            }
        }
        for (Map.Entry<String, LangChain4jBuildConfig.BaseConfig> entry : buildConfig.namedConfig().entrySet()) {
            String provider3;
            String configNamespace3;
            Optional<String> userSelectedProvider4;
            LangChain4jBuildConfig.BaseConfig value = entry.getValue();
            if (!(requestedStreamingChatModels.contains(entry.getKey()) || requestedChatModels.contains(entry.getKey()) || value.chatModel().provider().isEmpty())) {
                Optional<String> userSelectedProvider5 = value.chatModel().provider();
                String configNamespace32 = entry.getKey() + ".chat-model";
                String provider5 = this.selectProvider(chatCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ChatLanguageModel.class), userSelectedProvider5, "ChatLanguageModel or StreamingChatLanguageModel", configNamespace32);
                if (provider5 != null) {
                    selectedChatProducer.produce((BuildItem)new SelectedChatModelProviderBuildItem(provider5, entry.getKey()));
                }
            }
            if (!requestEmbeddingModels.contains(entry.getKey()) && !value.embeddingModel().provider().isEmpty()) {
                userSelectedProvider4 = value.embeddingModel().provider();
                configNamespace3 = entry.getKey() + ".embedding-model";
                provider3 = this.selectEmbeddingModelProvider(inProcessEmbeddingBuildItems, embeddingCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(EmbeddingModel.class), userSelectedProvider4, "EmbeddingModel", configNamespace3);
                if (provider3 != null) {
                    selectedEmbeddingProducer.produce((BuildItem)new SelectedEmbeddingModelCandidateBuildItem(provider3, entry.getKey()));
                }
            }
            if (!requestScoringModels.contains(entry.getKey()) && !value.scoringModel().provider().isEmpty()) {
                userSelectedProvider4 = value.scoringModel().provider();
                configNamespace3 = entry.getKey() + ".scoring-model";
                provider3 = this.selectProvider(scoringCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ScoringModel.class), userSelectedProvider4, "ScoringModel", configNamespace3);
                if (provider3 != null) {
                    selectedScoringProducer.produce((BuildItem)new SelectedScoringModelProviderBuildItem(provider3, entry.getKey()));
                }
            }
            if (!requestedModerationModels.contains(entry.getKey()) && !value.moderationModel().provider().isEmpty()) {
                userSelectedProvider4 = value.moderationModel().provider();
                configNamespace3 = entry.getKey() + ".moderation-model";
                provider3 = this.selectProvider(moderationCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ModerationModel.class), userSelectedProvider4, "ModerationModel", configNamespace3);
                if (provider3 != null) {
                    selectedModerationProducer.produce((BuildItem)new SelectedModerationModelProviderBuildItem(provider3, entry.getKey()));
                }
            }
            if (requestedImageModels.contains(entry.getKey()) || value.imageModel().provider().isEmpty()) continue;
            userSelectedProvider4 = value.imageModel().provider();
            configNamespace3 = entry.getKey() + ".image-model";
            provider3 = this.selectProvider(imageCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ImageModel.class), userSelectedProvider4, "ImageModel", configNamespace3);
            if (provider3 == null) continue;
            selectedImageProducer.produce((BuildItem)new SelectedImageModelProviderBuildItem(provider3, entry.getKey()));
        }
    }

    private String determineModelName(InjectionPointInfo ip) {
        String value;
        AnnotationInstance modelNameInstance = ip.getRequiredQualifier(LangChain4jDotNames.MODEL_NAME);
        if (modelNameInstance != null && (value = modelNameInstance.value().asString()) != null && !value.isEmpty()) {
            return value;
        }
        if (modelNameInstance == null && ip.isProgrammaticLookup()) {
            return null;
        }
        return "<default>";
    }

    private <T extends ProviderHolder> String selectProvider(List<T> candidateItems, BeanStream beanStream, Optional<String> userSelectedProvider, String beanType, String configNamespace) {
        List availableProviders = candidateItems.stream().map(ProviderHolder::getProvider).collect(Collectors.toList());
        if (availableProviders.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but no langchain4j providers were configured. Consider adding an extension like 'quarkus-langchain4j-openai'", beanType));
            }
            return null;
        }
        if (availableProviders.size() == 1) {
            if (userSelectedProvider.isPresent() && !((String)availableProviders.get(0)).equals(userSelectedProvider.get())) {
                throw new ConfigurationException(String.format("A %s bean with provider=%s was requested was requested via configuration, but the only provider found on the classpath is %s.", beanType, userSelectedProvider.get(), availableProviders.get(0)));
            }
            return (String)availableProviders.get(0);
        }
        if (userSelectedProvider.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but since there are multiple available providers, the 'quarkus.langchain4j.%s.provider' needs to be set to one of the available options (%s).", beanType, configNamespace, String.join((CharSequence)",", availableProviders)));
            }
            return null;
        }
        boolean matches = availableProviders.stream().anyMatch(ap -> ap.equals(userSelectedProvider.get()));
        if (matches) {
            return userSelectedProvider.get();
        }
        if (beanStream.collect().isEmpty()) {
            throw new ConfigurationException(String.format("A %s bean was requested, but the value of 'quarkus.langchain4j.%s.provider' does not match any of the available options (%s).", beanType, configNamespace, String.join((CharSequence)",", availableProviders)));
        }
        return null;
    }

    private <T extends ProviderHolder> String selectEmbeddingModelProvider(List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems, List<T> chatCandidateItems, BeanStream beanStream, Optional<String> userSelectedProvider, String requestedBeanName, String configNamespace) {
        List availableProviders = chatCandidateItems.stream().map(ProviderHolder::getProvider).collect(Collectors.toList());
        availableProviders.addAll(inProcessEmbeddingBuildItems.stream().map(InProcessEmbeddingBuildItem::getProvider).toList());
        if (availableProviders.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but no langchain4j providers were configured and no in-process embedding model were found on the classpath. Consider adding an extension like 'quarkus-langchain4j-openai' or one of the in-process embedding models.", requestedBeanName));
            }
            return null;
        }
        if (availableProviders.size() == 1) {
            if (userSelectedProvider.isPresent() && !((String)availableProviders.get(0)).equals(userSelectedProvider.get())) {
                throw new ConfigurationException(String.format("Embedding model provider %s was requested via configuration, but the only provider found on the classpath is %s.", userSelectedProvider.get(), availableProviders.get(0)));
            }
            return (String)availableProviders.get(0);
        }
        if (userSelectedProvider.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but since there are multiple available providers, the 'quarkus.langchain4j.%s.provider' needs to be set to one of the available options (%s).", requestedBeanName, configNamespace, String.join((CharSequence)",", availableProviders)));
            }
            return null;
        }
        boolean matches = availableProviders.stream().anyMatch(ap -> ap.equals(userSelectedProvider.get()));
        if (matches) {
            return userSelectedProvider.get();
        }
        if (beanStream.collect().isEmpty()) {
            throw new ConfigurationException(String.format("A %s bean was requested, but the value of 'quarkus.langchain4j.%s.provider' does not match any of the available options (%s).", requestedBeanName, configNamespace, String.join((CharSequence)",", availableProviders)));
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void cleanUp(LangChain4jRecorder recorder, ShutdownContextBuildItem shutdown) {
        recorder.cleanUp((ShutdownContext)shutdown);
    }

    @BuildStep
    public void unremovableBeans(BuildProducer<UnremovableBeanBuildItem> unremovableProducer) {
        unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
        unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ModelAuthProvider.class}));
    }

    @BuildStep
    void logCleanupFilters(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilters) {
        logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("ai.djl.util.Platform", Level.INFO, new String[]{"Found matching platform from"}));
        logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("ai.djl.huggingface.tokenizers.jni.LibUtils", Level.INFO, new String[]{"Extracting"}));
    }

    @BuildStep
    public void nativeSupport(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("dev.langchain4j.internal.RetryUtils"));
    }
}

