/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ai.runtime.gemini;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiChatLanguageModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiEmbeddingModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.AiGeminiStreamingChatLanguageModel;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.ChatModelConfig;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.LangChain4jAiGeminiConfig;
import io.quarkiverse.langchain4j.ai.runtime.gemini.config.LangChain4jAiGeminiEmbeddingConfig;
import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Recorder
public class AiGeminiRecorder {
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};
    private static final TypeLiteral<Instance<ModelAuthProvider>> MODEL_AUTH_PROVIDER_TYPE_LITERAL = new TypeLiteral<Instance<ModelAuthProvider>>(){};
    private final RuntimeValue<LangChain4jAiGeminiConfig> runtimeConfig;

    public AiGeminiRecorder(RuntimeValue<LangChain4jAiGeminiConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Function<SyntheticCreationalContext<EmbeddingModel>, EmbeddingModel> embeddingModel(final String configName) {
        LangChain4jAiGeminiConfig.AiGeminiConfig aiConfig = this.correspondingAiConfig(configName);
        if (aiConfig.enableIntegration().booleanValue()) {
            LangChain4jAiGeminiEmbeddingConfig embeddingModelConfig = aiConfig.embeddingModel();
            Optional<String> baseUrl = aiConfig.baseUrl();
            final String apiKey = aiConfig.apiKey().orElse(null);
            final AiGeminiEmbeddingModel.Builder builder = AiGeminiEmbeddingModel.builder().configName(configName).baseUrl(baseUrl).key(apiKey).modelId(embeddingModelConfig.modelId()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), aiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), aiConfig.logResponses()}));
            if (embeddingModelConfig.outputDimension().isPresent()) {
                builder.dimension(embeddingModelConfig.outputDimension().get());
            }
            if (embeddingModelConfig.taskType().isPresent()) {
                builder.taskType(embeddingModelConfig.taskType().get());
            }
            return new Function<SyntheticCreationalContext<EmbeddingModel>, EmbeddingModel>(this){
                final /* synthetic */ AiGeminiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingModel apply(SyntheticCreationalContext<EmbeddingModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, AiGeminiRecorder.isAuthProviderAvailable(context, configName), configName);
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<EmbeddingModel>, EmbeddingModel>(){

            @Override
            public EmbeddingModel apply(SyntheticCreationalContext<EmbeddingModel> context) {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> chatModel(final String configName) {
        LangChain4jAiGeminiConfig.AiGeminiConfig aiConfig = this.correspondingAiConfig(configName);
        if (aiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig.ThinkingConfig thinkingConfig;
            ChatModelConfig chatModelConfig = aiConfig.chatModel();
            Optional<String> baseUrl = aiConfig.baseUrl();
            final String apiKey = aiConfig.apiKey().orElse(null);
            final AiGeminiChatLanguageModel.Builder builder = AiGeminiChatLanguageModel.builder().baseUrl(baseUrl).key(apiKey).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), aiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), aiConfig.logResponses()}));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(chatModelConfig.temperature().getAsDouble());
            }
            if (chatModelConfig.topK().isPresent()) {
                builder.topK(chatModelConfig.topK().getAsInt());
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(chatModelConfig.topP().getAsDouble());
            }
            if (chatModelConfig.timeout().isPresent()) {
                builder.timeout(chatModelConfig.timeout().get());
            }
            if ((thinkingConfig = chatModelConfig.thinking()).includeThoughts()) {
                builder.includeThoughts(thinkingConfig.includeThoughts());
            }
            if (thinkingConfig.thinkingBudget().isPresent()) {
                builder.thinkingBudget(thinkingConfig.thinkingBudget().getAsLong());
            }
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ AiGeminiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, AiGeminiRecorder.isAuthProviderAvailable(context, configName), configName);
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> streamingChatModel(final String configName) {
        LangChain4jAiGeminiConfig.AiGeminiConfig aiConfig = this.correspondingAiConfig(configName);
        if (aiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = aiConfig.chatModel();
            Optional<String> baseUrl = aiConfig.baseUrl();
            final String apiKey = aiConfig.apiKey().orElse(null);
            final AiGeminiStreamingChatLanguageModel.Builder builder = AiGeminiStreamingChatLanguageModel.builder().baseUrl(baseUrl).key(apiKey).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), aiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), aiConfig.logResponses()}));
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(chatModelConfig.temperature().getAsDouble());
            }
            if (chatModelConfig.topK().isPresent()) {
                builder.topK(chatModelConfig.topK().getAsInt());
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(chatModelConfig.topP().getAsDouble());
            }
            if (chatModelConfig.timeout().isPresent()) {
                builder.timeout(chatModelConfig.timeout().get());
            }
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ AiGeminiRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    this.this$0.throwIfApiKeysNotConfigured(apiKey, AiGeminiRecorder.isAuthProviderAvailable(context, configName), configName);
                    builder.listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().collect(Collectors.toList()));
                    return builder.build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    private void throwIfApiKeysNotConfigured(String apiKey, boolean authProviderAvailable, String configName) {
        if (apiKey == null && !authProviderAvailable) {
            throw new ConfigValidationException(AiGeminiRecorder.createConfigProblems("api-key", configName));
        }
    }

    private static <T> boolean isAuthProviderAvailable(SyntheticCreationalContext<T> context, String configName) {
        return ((Instance)context.getInjectedReference(MODEL_AUTH_PROVIDER_TYPE_LITERAL, new Annotation[0])).isResolvable();
    }

    private LangChain4jAiGeminiConfig.AiGeminiConfig correspondingAiConfig(String configName) {
        return NamedConfigUtil.isDefault((String)configName) ? ((LangChain4jAiGeminiConfig)this.runtimeConfig.getValue()).defaultConfig() : ((LangChain4jAiGeminiConfig)this.runtimeConfig.getValue()).namedConfig().get(configName);
    }

    private static ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{AiGeminiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem("SRCFG00014: The config property quarkus.langchain4j.ai.gemini%s%s is required but it could not be found in any config source".formatted(NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

