/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.ws.security;

import io.quarkiverse.cxf.ws.security.WssConfigurationConstant;
import io.quarkus.runtime.annotations.ConfigDocFilename;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.cxf")
@ConfigDocFilename(value="quarkus-cxf-rt-ws-security.adoc")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface CxfWsSecurityConfig {
    @WithName(value="client")
    @ConfigDocMapKey(value="client-name")
    public Map<String, ClientConfig> clients();

    @WithName(value="endpoint")
    @ConfigDocMapKey(value="/endpoint-path")
    public Map<String, EndpointConfig> endpoints();

    public static interface FutureStsConfig {
        @WssConfigurationConstant(key="security.sts.applies-to")
        public Optional<String> stsAppliesTo();

        @WssConfigurationConstant(key="security.sts.token.do.cancel")
        public Optional<String> stsTokenDoCancel();

        @WssConfigurationConstant(key="security.issue.after.failed.renew")
        public Optional<String> stsIssueAfterFailedRenew();

        @WssConfigurationConstant(key="security.cache.issued.token.in.endpoint")
        public Optional<String> cacheIssuedTokenInEndpoint();

        @WssConfigurationConstant(key="security.sts.disable-wsmex-call-using-epr-address")
        public Optional<String> disableStsClientWsmexCallUsingEprAddress();

        @WssConfigurationConstant(key="security.sts.prefer-wsmex")
        public Optional<String> preferWsmexOverStsClientConfig();

        @WssConfigurationConstant(key="security.sts.token.act-as")
        public Optional<String> stsTokenActAs();

        @WssConfigurationConstant(key="security.sts.token.on-behalf-of")
        public Optional<String> stsTokenOnBehalfOf();

        @WssConfigurationConstant(key="security.sts.token.imminent-expiry-value")
        public Optional<String> stsTokenImminentExpiryValue();

        @WssConfigurationConstant(key="security.sts.token.cacher.impl")
        public Optional<String> stsTokenCacherImpl();

        @WssConfigurationConstant(key="security.sts.check.for.recursive.call")
        public Optional<String> stsCheckForRecursiveCall();

        @WssConfigurationConstant(key="security.audience-restrictions")
        public Optional<String> audienceRestrictions();
    }

    public static interface StsClientConfig {
        @WithParentName
        @WssConfigurationConstant(key="security.sts.client", transformer=WssConfigurationConstant.Transformer.beanRef)
        public Optional<String> client();

        public Optional<String> wsdl();

        public Optional<String> serviceName();

        public Optional<String> endpointName();

        @WssConfigurationConstant(key="security.username")
        public Optional<String> username();

        @WssConfigurationConstant(key="security.password")
        public Optional<String> password();

        @WssConfigurationConstant(key="security.encryption.username")
        @WithName(value="encryption.username")
        public Optional<String> encryptionUsername();

        @WssConfigurationConstant(key="security.encryption.properties", transformer=WssConfigurationConstant.Transformer.properties)
        @WithName(value="encryption.properties")
        public Map<String, String> encryptionProperties();

        @WssConfigurationConstant(key="security.encryption.crypto", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="encryption.crypto")
        public Optional<String> encryptionCrypto();

        @WssConfigurationConstant(key="security.sts.token.crypto", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="token.crypto")
        public Optional<String> tokenCrypto();

        @WssConfigurationConstant(key="security.sts.token.properties", transformer=WssConfigurationConstant.Transformer.properties)
        @WithName(value="token.properties")
        public Map<String, String> tokenProperties();

        @WssConfigurationConstant(key="security.sts.token.username")
        @WithName(value="token.username")
        public Optional<String> tokenUsername();

        @WssConfigurationConstant(key="security.sts.token.usecert")
        @WithName(value="token.usecert")
        @WithDefault(value="false")
        public boolean tokenUsecert();

        @WssConfigurationConstant(key="security.sts.client-soap12-binding")
        @WithName(value="soap12-binding")
        @WithDefault(value="false")
        public boolean soap12Binding();
    }

    public static interface ValidatorConfig {
        @WssConfigurationConstant(key="ws-security.ut.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="ut.validator")
        public Optional<String> usernameTokenValidator();

        @WssConfigurationConstant(key="ws-security.saml1.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="saml1.validator")
        public Optional<String> saml1TokenValidator();

        @WssConfigurationConstant(key="ws-security.saml2.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="saml2.validator")
        public Optional<String> saml2TokenValidator();

        @WssConfigurationConstant(key="ws-security.timestamp.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="timestamp.validator")
        public Optional<String> timestampTokenValidator();

        @WssConfigurationConstant(key="ws-security.signature.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="signature.validator")
        public Optional<String> signatureTokenValidator();

        @WssConfigurationConstant(key="ws-security.bst.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="bst.validator")
        public Optional<String> bstTokenValidator();

        @WssConfigurationConstant(key="ws-security.sct.validator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="sct.validator")
        public Optional<String> sctTokenValidator();

        @WssConfigurationConstant(key="ws-security.policy.validator.map", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="policy.validator.map")
        public Optional<String> policyValidatorMap();
    }

    @ConfigGroup
    public static interface ClientSecurityConfig
    extends ClientOrEndpointSecurityConfig {
        @WithName(value="sts.client")
        public StsClientConfig sts();
    }

    @ConfigGroup
    public static interface ClientOrEndpointSecurityConfig {
        public static final String CUSTOM_ALGORITHM_SUITE_NAME = "CustomAlgorithmSuite";

        @WssConfigurationConstant(key="security.username")
        public Optional<String> username();

        @WssConfigurationConstant(key="security.password")
        public Optional<String> password();

        @WssConfigurationConstant(key="security.signature.username")
        @WithName(value="signature.username")
        public Optional<String> signatureUsername();

        @WssConfigurationConstant(key="security.signature.password")
        @WithName(value="signature.password")
        public Optional<String> signaturePassword();

        @WssConfigurationConstant(key="security.encryption.username")
        @WithName(value="encryption.username")
        public Optional<String> encryptionUsername();

        @WssConfigurationConstant(key="security.callback-handler", transformer=WssConfigurationConstant.Transformer.beanRef)
        public Optional<String> callbackHandler();

        @WssConfigurationConstant(key="security.saml-callback-handler", transformer=WssConfigurationConstant.Transformer.beanRef)
        public Optional<String> samlCallbackHandler();

        @WssConfigurationConstant(key="security.signature.properties", transformer=WssConfigurationConstant.Transformer.properties)
        @WithName(value="signature.properties")
        public Map<String, String> signatureProperties();

        @WssConfigurationConstant(key="security.encryption.properties", transformer=WssConfigurationConstant.Transformer.properties)
        @WithName(value="encryption.properties")
        public Map<String, String> encryptionProperties();

        @WssConfigurationConstant(key="security.signature.crypto", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="signature.crypto")
        public Optional<String> signatureCrypto();

        @WssConfigurationConstant(key="security.encryption.crypto", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="encryption.crypto")
        public Optional<String> encryptionCrypto();

        @WssConfigurationConstant(key="security.encryption.certificate")
        @WithName(value="encryption.certificate")
        public Optional<String> encryptionCertificate();

        @WssConfigurationConstant(key="security.enableRevocation")
        @WithDefault(value="false")
        public boolean enableRevocation();

        @WssConfigurationConstant(key="security.enable.unsigned-saml-assertion.principal")
        @WithDefault(value="false")
        public boolean enableUnsignedSamlAssertionPrincipal();

        @WssConfigurationConstant(key="security.validate.saml.subject.conf")
        @WithDefault(value="true")
        public boolean validateSamlSubjectConfirmation();

        @WssConfigurationConstant(key="security.sc.jaas-subject")
        @WithDefault(value="true")
        public boolean scFromJaasSubject();

        @WssConfigurationConstant(key="security.validate.audience-restriction")
        @WithDefault(value="true")
        public boolean audienceRestrictionValidation();

        @WssConfigurationConstant(key="security.saml-role-attributename")
        @WithDefault(value="http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role")
        public String samlRoleAttributename();

        @WssConfigurationConstant(key="security.subject.cert.constraints")
        public Optional<String> subjectCertConstraints();

        @WssConfigurationConstant(key="security.cert.constraints.separator")
        @WithDefault(value=",")
        public String certConstraintsSeparator();

        @WssConfigurationConstant(key="ws-security.actor")
        @WithName(value="actor")
        public Optional<String> actor();

        @WssConfigurationConstant(key="ws-security.validate.token")
        @WithName(value="validate.token")
        @WithDefault(value="true")
        public boolean validateToken();

        @WssConfigurationConstant(key="ws-security.username-token.always.encrypted")
        @WithName(value="username-token.always.encrypted")
        @WithDefault(value="true")
        public boolean alwaysEncryptUt();

        @WssConfigurationConstant(key="ws-security.is-bsp-compliant")
        @WithName(value="is-bsp-compliant")
        @WithDefault(value="true")
        public boolean isBspCompliant();

        @WssConfigurationConstant(key="ws-security.enable.nonce.cache")
        @WithName(value="enable.nonce.cache")
        public Optional<Boolean> enableNonceCache();

        @WssConfigurationConstant(key="ws-security.enable.timestamp.cache")
        @WithName(value="enable.timestamp.cache")
        public Optional<Boolean> enableTimestampCache();

        @WssConfigurationConstant(key="ws-security.enable.streaming")
        @WithName(value="enable.streaming")
        @WithDefault(value="false")
        public boolean enableStreaming();

        @WssConfigurationConstant(key="ws-security.return.security.error")
        @WithName(value="return.security.error")
        @WithDefault(value="false")
        public boolean returnSecurityError();

        @WssConfigurationConstant(key="ws-security.must-understand")
        @WithName(value="must-understand")
        @WithDefault(value="true")
        public boolean mustUnderstand();

        @WssConfigurationConstant(key="ws-security.enable.saml.cache")
        @WithName(value="enable.saml.cache")
        public Optional<Boolean> enableSamlOneTimeUseCache();

        @WssConfigurationConstant(key="ws-security.store.bytes.in.attachment")
        @WithName(value="store.bytes.in.attachment")
        public Optional<Boolean> storeBytesInAttachment();

        @WssConfigurationConstant(key="ws-security.swa.encryption.attachment.transform.content")
        @WithName(value="swa.encryption.attachment.transform.content")
        @WithDefault(value="false")
        public boolean useAttachmentEncryptionContentOnlyTransform();

        @WssConfigurationConstant(key="ws-security.use.str.transform")
        @WithName(value="use.str.transform")
        @WithDefault(value="true")
        public boolean useStrTransform();

        @WssConfigurationConstant(key="ws-security.add.inclusive.prefixes")
        @WithName(value="add.inclusive.prefixes")
        @WithDefault(value="true")
        public boolean addInclusivePrefixes();

        @WssConfigurationConstant(key="ws-security.disable.require.client.cert.check")
        @WithName(value="disable.require.client.cert.check")
        @WithDefault(value="false")
        public boolean disableReqClientCertCheck();

        @WssConfigurationConstant(key="ws-security.expand.xop.include")
        @WithName(value="expand.xop.include")
        public Optional<Boolean> expandXopInclude();

        @WssConfigurationConstant(key="ws-security.timestamp.timeToLive")
        @WithName(value="timestamp.timeToLive")
        @WithDefault(value="300")
        public Optional<String> timestampTtl();

        @WssConfigurationConstant(key="ws-security.timestamp.futureTimeToLive")
        @WithName(value="timestamp.futureTimeToLive")
        @WithDefault(value="60")
        public Optional<String> timestampFutureTtl();

        @WssConfigurationConstant(key="ws-security.usernametoken.timeToLive")
        @WithName(value="usernametoken.timeToLive")
        @WithDefault(value="300")
        public Optional<String> usernametokenTtl();

        @WssConfigurationConstant(key="ws-security.usernametoken.futureTimeToLive")
        @WithName(value="usernametoken.futureTimeToLive")
        @WithDefault(value="60")
        public Optional<String> usernametokenFutureTtl();

        @WssConfigurationConstant(key="ws-security.spnego.client.action", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="spnego.client.action")
        public Optional<String> spnegoClientAction();

        @WssConfigurationConstant(key="ws-security.nonce.cache.instance", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="nonce.cache.instance")
        public Optional<String> nonceCacheInstance();

        @WssConfigurationConstant(key="ws-security.timestamp.cache.instance", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="timestamp.cache.instance")
        public Optional<String> timestampCacheInstance();

        @WssConfigurationConstant(key="ws-security.saml.cache.instance", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="saml.cache.instance")
        public Optional<String> samlOneTimeUseCacheInstance();

        @WssConfigurationConstant(key="ws-security.cache.config.file")
        @WithName(value="cache.config.file")
        public Optional<String> cacheConfigFile();

        @WssConfigurationConstant(key="org.apache.cxf.ws.security.tokenstore.TokenStore", transformer=WssConfigurationConstant.Transformer.beanRef)
        public Optional<String> tokenStoreCacheInstance();

        @WssConfigurationConstant(key="ws-security.cache.identifier")
        @WithName(value="cache.identifier")
        public Optional<String> cacheIdentifier();

        @WssConfigurationConstant(key="ws-security.role.classifier")
        @WithName(value="role.classifier")
        public Optional<String> subjectRoleClassifier();

        @WssConfigurationConstant(key="ws-security.role.classifier.type")
        @WithName(value="role.classifier.type")
        @WithDefault(value="prefix")
        public String subjectRoleClassifierType();

        @WssConfigurationConstant(key="ws-security.asymmetric.signature.algorithm")
        @WithName(value="asymmetric.signature.algorithm")
        public Optional<String> asymmetricSignatureAlgorithm();

        @WssConfigurationConstant(key="ws-security.symmetric.signature.algorithm")
        @WithName(value="symmetric.signature.algorithm")
        public Optional<String> symmetricSignatureAlgorithm();

        @WssConfigurationConstant(key="ws-security.password.encryptor.instance", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="password.encryptor.instance")
        public Optional<String> passwordEncryptorInstance();

        @WssConfigurationConstant(key="ws-security.delegated.credential", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="delegated.credential")
        public Optional<String> delegatedCredential();

        @WssConfigurationConstant(key="ws-security.security.context.creator", transformer=WssConfigurationConstant.Transformer.beanRef)
        @WithName(value="security.context.creator")
        public Optional<String> securityContextCreator();

        @WssConfigurationConstant(key="ws-security.security.token.lifetime")
        @WithName(value="security.token.lifetime")
        @WithDefault(value="300000")
        public long securityTokenLifetime();

        @WssConfigurationConstant(key="ws-security.kerberos.request.credential.delegation")
        @WithName(value="kerberos.request.credential.delegation")
        @WithDefault(value="false")
        public boolean kerberosRequestCredentialDelegation();

        @WssConfigurationConstant(key="ws-security.kerberos.use.credential.delegation")
        @WithName(value="kerberos.use.credential.delegation")
        @WithDefault(value="false")
        public boolean kerberosUseCredentialDelegation();

        @WssConfigurationConstant(key="ws-security.kerberos.is.username.in.servicename.form")
        @WithName(value="kerberos.is.username.in.servicename.form")
        @WithDefault(value="false")
        public boolean kerberosIsUsernameInServicenameForm();

        @WssConfigurationConstant(key="ws-security.kerberos.jaas.context")
        @WithName(value="kerberos.jaas.context")
        public Optional<String> kerberosJaasContextName();

        @WssConfigurationConstant(key="ws-security.kerberos.spn")
        @WithName(value="kerberos.spn")
        public Optional<String> kerberosSpn();

        @WssConfigurationConstant(key="ws-security.kerberos.client")
        @WithName(value="kerberos.client")
        public Optional<String> kerberosClient();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.digest.algorithm")
        @WithName(value="custom.digest.algorithm")
        @WithDefault(value="http://www.w3.org/2001/04/xmlenc#sha256")
        public String digestAlgorithm();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.encryption.algorithm")
        @WithName(value="custom.encryption.algorithm")
        @WithDefault(value="http://www.w3.org/2009/xmlenc11#aes256-gcm")
        public String encryptionAlgorithm();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.symmetric.key.encryption.algorithm")
        @WithName(value="custom.symmetric.key.encryption.algorithm")
        @WithDefault(value="http://www.w3.org/2001/04/xmlenc#kw-aes256")
        public String symmetricKeyEncryptionAlgorithm();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.asymmetric.key.encryption.algorithm")
        @WithName(value="custom.asymmetric.key.encryption.algorithm")
        @WithDefault(value="http://www.w3.org/2001/04/xmlenc#rsa-1_5")
        public String asymmetricKeyEncryptionAlgorithm();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.encryption.key.derivation")
        @WithName(value="custom.encryption.key.derivation")
        @WithDefault(value="http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1")
        public String encryptionKeyDerivation();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.signature.key.derivation")
        @WithName(value="custom.signature.key.derivation")
        @WithDefault(value="http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1")
        public String signatureKeyDerivation();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.encryption.derived.key.length", transformer=WssConfigurationConstant.Transformer.toInteger)
        @WithName(value="custom.encryption.derived.key.length")
        @WithDefault(value="256")
        public Integer encryptionDerivedKeyLength();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.signature.derived.key.length", transformer=WssConfigurationConstant.Transformer.toInteger)
        @WithName(value="custom.signature.derived.key.length")
        @WithDefault(value="192")
        public Integer signatureDerivedKeyLength();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.minimum.symmetric.key.length", transformer=WssConfigurationConstant.Transformer.toInteger)
        @WithName(value="custom.minimum.symmetric.key.length")
        @WithDefault(value="256")
        public Integer minimumSymmetricKeyLength();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.maximum.symmetric.key.length", transformer=WssConfigurationConstant.Transformer.toInteger)
        @WithName(value="custom.maximum.symmetric.key.length")
        @WithDefault(value="256")
        public Integer maximumSymmetricKeyLength();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.minimum.asymmetric.key.length", transformer=WssConfigurationConstant.Transformer.toInteger)
        @WithName(value="custom.minimum.asymmetric.key.length")
        @WithDefault(value="1024")
        public Integer minimumAsymmetricKeyLength();

        @WssConfigurationConstant(key="ws-security.custom.alg.suite.maximum.asymmetric.key.length", transformer=WssConfigurationConstant.Transformer.toInteger)
        @WithName(value="custom.maximum.asymmetric.key.length")
        @WithDefault(value="4096")
        public Integer maximumAsymmetricKeyLength();
    }

    @ConfigGroup
    public static interface EndpointConfig {
        public ClientOrEndpointSecurityConfig security();
    }

    @ConfigGroup
    public static interface ClientConfig {
        public ClientSecurityConfig security();
    }
}

