/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.secretsmanager.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

@ApplicationScoped
public class SecretsManagerClientProducer {
    private final SecretsManagerClient syncClient;
    private final SecretsManagerAsyncClient asyncClient;

    SecretsManagerClientProducer(Instance<SecretsManagerClientBuilder> syncClientBuilderInstance, Instance<SecretsManagerAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (SecretsManagerClient)((SecretsManagerClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (SecretsManagerAsyncClient)((SecretsManagerAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SecretsManagerClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The SecretsManagerClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SecretsManagerAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The SecretsManagerAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

