/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.config;

import javax.annotation.Nullable;

public enum EscapingScheme {
    ALLOW_UTF8("allow-utf-8"),
    UNDERSCORE_ESCAPING("underscores"),
    DOTS_ESCAPING("dots"),
    VALUE_ENCODING_ESCAPING("values");

    private static final String ESCAPING_KEY = "escaping";
    public static final EscapingScheme DEFAULT;
    private final String value;

    public final String getValue() {
        return this.value;
    }

    private EscapingScheme(String value) {
        this.value = value;
    }

    public static EscapingScheme fromAcceptHeader(@Nullable String acceptHeader) {
        if (acceptHeader != null) {
            for (String p : acceptHeader.split(";")) {
                String[] toks = p.split("=");
                if (toks.length != 2) continue;
                String key = toks[0].trim();
                String value = toks[1].trim();
                if (!key.equals(ESCAPING_KEY)) continue;
                try {
                    return EscapingScheme.forString(value);
                }
                catch (IllegalArgumentException e) {
                    return DEFAULT;
                }
            }
        }
        return DEFAULT;
    }

    static EscapingScheme forString(String value) {
        switch (value) {
            case "allow-utf-8": {
                return ALLOW_UTF8;
            }
            case "underscores": {
                return UNDERSCORE_ESCAPING;
            }
            case "dots": {
                return DOTS_ESCAPING;
            }
            case "values": {
                return VALUE_ENCODING_ESCAPING;
            }
        }
        throw new IllegalArgumentException("Unknown escaping scheme: " + value);
    }

    public String toHeaderFormat() {
        return "; escaping=" + this.value;
    }

    static {
        DEFAULT = UNDERSCORE_ESCAPING;
    }
}

