/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.quic.QuicChannel;
import io.netty.handler.codec.quic.QuicStreamChannelBootstrap;
import io.netty.handler.codec.quic.QuicStreamType;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.quic.QuicConnection;
import reactor.netty.quic.QuicInbound;
import reactor.netty.quic.QuicOutbound;
import reactor.netty.quic.QuicStreamOperations;
import reactor.netty.quic.QuicTransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class QuicOperations
implements ChannelOperationsId,
QuicConnection {
    final @Nullable ChannelHandler loggingHandler;
    final QuicChannel quicChannel;
    final String shortId;
    final Map<AttributeKey<?>, ?> streamAttrs;
    final ConnectionObserver streamListener;
    final Map<ChannelOption<?>, ?> streamOptions;
    static final char CHANNEL_ID_PREFIX = '[';
    static final Logger log = Loggers.getLogger(QuicOperations.class);
    static final String ORIGINAL_CHANNEL_ID_PREFIX = "[id: 0x";
    static final int ORIGINAL_CHANNEL_ID_PREFIX_LENGTH = "[id: 0x".length();

    QuicOperations(QuicChannel quicChannel, @Nullable ChannelHandler loggingHandler, ConnectionObserver streamListener, Map<AttributeKey<?>, ?> streamAttrs, Map<ChannelOption<?>, ?> streamOptions) {
        this.loggingHandler = loggingHandler;
        this.quicChannel = quicChannel;
        this.shortId = this.channel().id().asShortText();
        this.streamAttrs = streamAttrs;
        this.streamListener = streamListener;
        this.streamOptions = streamOptions;
    }

    public String asLongText() {
        String channelStr = this.channel().toString();
        int ind = channelStr.indexOf(ORIGINAL_CHANNEL_ID_PREFIX);
        return new StringBuilder(1 + (channelStr.length() - ORIGINAL_CHANNEL_ID_PREFIX_LENGTH)).append(channelStr.substring(0, ind)).append('[').append(channelStr.substring(ind + ORIGINAL_CHANNEL_ID_PREFIX_LENGTH)).toString();
    }

    public String asShortText() {
        return this.shortId;
    }

    public Channel channel() {
        return this.quicChannel;
    }

    @Override
    public Mono<Void> createStream(QuicStreamType streamType, BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler) {
        Objects.requireNonNull(streamType, "streamType");
        Objects.requireNonNull(streamHandler, "streamHandler");
        return Mono.create(sink -> {
            QuicStreamChannelBootstrap bootstrap = this.quicChannel.newStreamBootstrap();
            bootstrap.type(streamType).handler(QuicTransportConfig.streamChannelInitializer(this.loggingHandler, this.streamListener.then((ConnectionObserver)new QuicStreamChannelObserver((MonoSink<Void>)sink, streamHandler)), false));
            QuicOperations.setAttributes(bootstrap, this.streamAttrs);
            QuicOperations.setChannelOptions(bootstrap, this.streamOptions);
            bootstrap.create().addListener(f -> {
                if (!f.isSuccess()) {
                    if (f.cause() != null) {
                        sink.error(f.cause());
                    } else {
                        sink.error((Throwable)new IOException("Cannot create stream"));
                    }
                }
            });
        });
    }

    static void setAttributes(QuicStreamChannelBootstrap bootstrap, Map<AttributeKey<?>, ?> attrs) {
        for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
            bootstrap.attr(e.getKey(), e.getValue());
        }
    }

    static void setChannelOptions(QuicStreamChannelBootstrap bootstrap, Map<ChannelOption<?>, ?> options) {
        for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
            bootstrap.option(e.getKey(), e.getValue());
        }
    }

    static final class QuicStreamChannelObserver
    implements ConnectionObserver {
        final Context currentContext;
        final MonoSink<Void> sink;
        final BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler;

        QuicStreamChannelObserver(MonoSink<Void> sink, BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler) {
            this.currentContext = Context.of((ContextView)sink.contextView());
            this.sink = sink;
            this.streamHandler = streamHandler;
        }

        public Context currentContext() {
            return this.currentContext;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)connection.channel(), (String)"Handler is being applied: {}"), new Object[]{this.streamHandler});
                    }
                    QuicStreamOperations ops = (QuicStreamOperations)connection;
                    Mono.fromDirect(this.streamHandler.apply(ops, ops)).subscribe(ops.disposeSubscriber());
                }
                catch (Throwable t) {
                    log.error(ReactorNetty.format((Channel)connection.channel(), (String)""), t);
                    connection.channel().close();
                }
            }
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.sink.error(error);
        }
    }
}

