/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.math.BigDecimal;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

public class MonoSumBigDecimal<T>
extends MonoFromFluxOperator<T, BigDecimal>
implements Fuseable {
    private final Function<? super T, ? extends Number> mapping;

    MonoSumBigDecimal(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    public void subscribe(CoreSubscriber<? super BigDecimal> actual) {
        this.source.subscribe(new SumBigDecimalSubscriber<T>(actual, this.mapping));
    }

    private static final class SumBigDecimalSubscriber<T>
    extends MathSubscriber<T, BigDecimal> {
        private final Function<? super T, ? extends Number> mapping;
        BigDecimal sum;
        boolean hasValue;

        SumBigDecimalSubscriber(CoreSubscriber<? super BigDecimal> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void reset() {
            this.sum = BigDecimal.ZERO;
            this.hasValue = false;
        }

        @Override
        protected BigDecimal result() {
            return this.hasValue ? this.sum : null;
        }

        @Override
        protected void updateResult(T newValue) {
            Number number = this.mapping.apply(newValue);
            BigDecimal bigDecimalValue = BigDecimal.valueOf(number.doubleValue());
            this.sum = this.hasValue ? this.sum.add(bigDecimalValue) : bigDecimalValue;
            this.hasValue = true;
        }
    }
}

