/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event.kvtable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.kvtable.TableRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class CreateTableEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scopeName;
    private final String kvtName;
    private final int partitionCount;
    private final long timestamp;
    private final long requestId;
    private final UUID tableId;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scopeName, this.kvtName);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((TableRequestProcessor)processor).processCreateKVTable(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CreateTableEventBuilder builder() {
        return new CreateTableEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScopeName() {
        return this.scopeName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKvtName() {
        return this.kvtName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getTableId() {
        return this.tableId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTableEvent)) {
            return false;
        }
        CreateTableEvent other = (CreateTableEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scopeName = this.getScopeName();
        String other$scopeName = other.getScopeName();
        if (this$scopeName == null ? other$scopeName != null : !this$scopeName.equals(other$scopeName)) {
            return false;
        }
        String this$kvtName = this.getKvtName();
        String other$kvtName = other.getKvtName();
        if (this$kvtName == null ? other$kvtName != null : !this$kvtName.equals(other$kvtName)) {
            return false;
        }
        if (this.getPartitionCount() != other.getPartitionCount()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        UUID this$tableId = this.getTableId();
        UUID other$tableId = other.getTableId();
        return !(this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateTableEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scopeName = this.getScopeName();
        result = result * 59 + ($scopeName == null ? 43 : $scopeName.hashCode());
        String $kvtName = this.getKvtName();
        result = result * 59 + ($kvtName == null ? 43 : $kvtName.hashCode());
        result = result * 59 + this.getPartitionCount();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        UUID $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CreateTableEvent(scopeName=" + this.getScopeName() + ", kvtName=" + this.getKvtName() + ", partitionCount=" + this.getPartitionCount() + ", timestamp=" + this.getTimestamp() + ", requestId=" + this.getRequestId() + ", tableId=" + this.getTableId() + ")";
    }

    @ConstructorProperties(value={"scopeName", "kvtName", "partitionCount", "timestamp", "requestId", "tableId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CreateTableEvent(String scopeName, String kvtName, int partitionCount, long timestamp, long requestId, UUID tableId) {
        this.scopeName = scopeName;
        this.kvtName = kvtName;
        this.partitionCount = partitionCount;
        this.timestamp = timestamp;
        this.requestId = requestId;
        this.tableId = tableId;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<CreateTableEvent, CreateTableEventBuilder> {
        protected CreateTableEventBuilder newBuilder() {
            return CreateTableEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(CreateTableEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scopeName);
            target.writeUTF(e.kvtName);
            target.writeInt(e.partitionCount);
            target.writeLong(e.timestamp);
            target.writeLong(e.requestId);
            target.writeUUID(e.tableId);
        }

        private void read00(RevisionDataInput source, CreateTableEventBuilder eb) throws IOException {
            eb.scopeName(source.readUTF());
            eb.kvtName(source.readUTF());
            eb.partitionCount(source.readInt());
            eb.timestamp(source.readLong());
            eb.requestId(source.readLong());
            eb.tableId(source.readUUID());
        }
    }

    private static class CreateTableEventBuilder
    implements ObjectBuilder<CreateTableEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scopeName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String kvtName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int partitionCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long timestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID tableId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CreateTableEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEventBuilder scopeName(String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEventBuilder kvtName(String kvtName) {
            this.kvtName = kvtName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEventBuilder partitionCount(int partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEventBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEventBuilder tableId(UUID tableId) {
            this.tableId = tableId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableEvent build() {
            return new CreateTableEvent(this.scopeName, this.kvtName, this.partitionCount, this.timestamp, this.requestId, this.tableId);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CreateTableEvent.CreateTableEventBuilder(scopeName=" + this.scopeName + ", kvtName=" + this.kvtName + ", partitionCount=" + this.partitionCount + ", timestamp=" + this.timestamp + ", requestId=" + this.requestId + ", tableId=" + this.tableId + ")";
        }
    }
}

