/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ConfigClientEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String PROPERTY_SOURCE_NAME = ConfigClientEnvironmentPostProcessor.class.getSimpleName();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        List configServices = new CfEnv().findServicesByTag(new String[]{"configuration"});
        if (configServices.size() != 1) {
            return;
        }
        CfCredentials credentials = ((CfService)configServices.get(0)).getCredentials();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spring.cloud.config.client.oauth2.client-id", credentials.getString(new String[]{"client_id"}));
        map.put("spring.cloud.config.client.oauth2.client-secret", credentials.getString(new String[]{"client_secret"}));
        map.put("spring.cloud.config.client.oauth2.access-token-uri", credentials.getString(new String[]{"access_token_uri"}));
        map.put("spring.cloud.config.client.oauth2.scope", "");
        map.put("spring.config.import", "optional:configserver:" + credentials.getUri(new String[0]));
        map.put("spring.cloud.refresh.additional-property-sources-to-retain", PROPERTY_SOURCE_NAME);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, map));
    }

    public int getOrder() {
        return -2147483639;
    }
}

