/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveSpan;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;

public class BraveScopeManager
implements ScopeManager {
    final Tracer tracer;

    BraveScopeManager(Tracer tracer) {
        this.tracer = tracer;
    }

    public BraveScope activate(io.opentracing.Span span) {
        if (span == null) {
            return null;
        }
        if (!(span instanceof BraveSpan)) {
            throw new IllegalArgumentException("Span must be an instance of brave.opentracing.BraveSpan, but was " + span.getClass());
        }
        return new BraveScope(this.tracer.withSpanInScope(((BraveSpan)span).delegate));
    }

    public BraveSpan activeSpan() {
        Span braveSpan = this.tracer.currentSpan();
        return braveSpan != null ? new BraveSpan(this.tracer, braveSpan) : null;
    }

    @Deprecated
    public Scope active() {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }

    @Deprecated
    public BraveScope activate(io.opentracing.Span span, boolean finishSpanOnClose) {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }

    @Deprecated
    BraveSpan currentSpan() {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }
}

