/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.trace.AttributeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class AttributesMap
extends HashMap<AttributeKey<?>, Object>
implements Attributes {
    private static final long serialVersionUID = -5072696312123632376L;
    private final long capacity;
    private final int lengthLimit;
    private int totalAddedValues = 0;

    AttributesMap(long capacity, int lengthLimit) {
        this.capacity = capacity;
        this.lengthLimit = lengthLimit;
    }

    @Override
    <T> void put(AttributeKey<T> key, T value) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(key)) {
            return;
        }
        super.put(key, AttributeUtil.applyAttributeLengthLimit(value, this.lengthLimit));
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Nullable
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this);
    }

    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll((Attributes)this);
    }

    @Override
    public String toString() {
        return "AttributesMap{data=" + super.toString() + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    Attributes immutableCopy() {
        return Attributes.builder().putAll((Attributes)this).build();
    }
}

