/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit4;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.ExternalResource;

public final class OpenTelemetryRule
extends ExternalResource {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;
    private final InMemoryMetricReader metricReader;

    public static OpenTelemetryRule create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        InMemoryMetricReader metricReader = InMemoryMetricReader.create();
        SdkMeterProvider meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)metricReader).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).setMeterProvider(meterProvider).build();
        return new OpenTelemetryRule(openTelemetry, spanExporter, metricReader);
    }

    private OpenTelemetryRule(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter, InMemoryMetricReader metricReader) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
        this.metricReader = metricReader;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public List<MetricData> getMetrics() {
        return new ArrayList<MetricData>(this.metricReader.collectAllMetrics());
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    public void clearMetrics() {
        SdkMeterProviderUtil.resetForTest((SdkMeterProvider)this.openTelemetry.getSdkMeterProvider());
    }

    protected void before() {
        GlobalOpenTelemetry.resetForTest();
        GlobalOpenTelemetry.set((OpenTelemetry)this.openTelemetry);
        this.clearSpans();
        this.clearMetrics();
    }

    protected void after() {
        GlobalOpenTelemetry.resetForTest();
    }
}

