/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.tapestry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.tapestry.TapestryRequest;
import io.opentelemetry.javaagent.instrumentation.tapestry.TapestrySingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tapestry5.internal.structure.ComponentPageElementImpl;

public class ComponentPageElementImplInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.apache.tapestry5.internal.structure.ComponentPageElementImpl");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"processEventTriggering")).and((ElementMatcher)ElementMatchers.takesArguments((int)3)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.tapestry5.EventContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.tapestry5.ComponentEventCallback"))), this.getClass().getName() + "$EventAdvice");
    }

    public static class EventAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.This ComponentPageElementImpl componentPageElementImpl, @Advice.Argument(value=0) String eventType, @Advice.Local(value="otelRequest") TapestryRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            request = new TapestryRequest(eventType, componentPageElementImpl.getCompleteId());
            if (!TapestrySingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = TapestrySingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") TapestryRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            TapestrySingletons.instrumenter().end(context, (Object)request, null, throwable);
        }
    }
}

