/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.spring.ws.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.spring.ws.v2_0.SpringWsRequest;
import io.opentelemetry.javaagent.instrumentation.spring.ws.v2_0.SpringWsSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;

public class AnnotatedMethodInstrumentation
implements TypeInstrumentation {
    private static final String[] ANNOTATION_CLASSES = new String[]{"org.springframework.ws.server.endpoint.annotation.PayloadRoot", "org.springframework.ws.soap.server.endpoint.annotation.SoapAction", "org.springframework.ws.soap.addressing.server.annotation.Action"};

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.springframework.ws.server.endpoint.annotation.PayloadRoot"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.declaresMethod((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.namedOneOf((String[])ANNOTATION_CLASSES)));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.namedOneOf((String[])ANNOTATION_CLASSES))), AnnotatedMethodInstrumentation.class.getName() + "$AnnotatedMethodAdvice");
    }

    public static class AnnotatedMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void startSpan(@Advice.Origin(value="#t") Class<?> codeClass, @Advice.Origin(value="#m") String methodName, @Advice.Local(value="otelCallDepth") CallDepth callDepth, @Advice.Local(value="otelRequest") SpringWsRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            callDepth = CallDepth.forClass(PayloadRoot.class);
            if (callDepth.getAndIncrement() > 0) {
                return;
            }
            Context parentContext = Java8BytecodeBridge.currentContext();
            request = SpringWsRequest.create(codeClass, methodName);
            if (!SpringWsSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = SpringWsSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelCallDepth") CallDepth callDepth, @Advice.Local(value="otelRequest") SpringWsRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (callDepth.decrementAndGet() > 0 || scope == null) {
                return;
            }
            scope.close();
            SpringWsSingletons.instrumenter().end(context, (Object)request, null, throwable);
        }
    }
}

