/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet;

import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.servlet.InjectionState;
import io.opentelemetry.javaagent.bootstrap.servlet.SnippetInjectingResponseWrapper;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper;
import jakarta.servlet.ServletOutputStream;
import javax.annotation.Nullable;

public class ServletOutputStreamInjectionState {
    private static final VirtualField<ServletOutputStream, InjectionState> virtualField = VirtualField.find(ServletOutputStream.class, InjectionState.class);

    public static void initializeInjectionStateIfNeeded(ServletOutputStream servletOutputStream, Servlet5SnippetInjectingResponseWrapper wrapper) {
        InjectionState state = (InjectionState)virtualField.get((Object)servletOutputStream);
        if (!wrapper.isContentTypeTextHtml()) {
            virtualField.set((Object)servletOutputStream, null);
            return;
        }
        if (state == null || state.getWrapper() != wrapper) {
            state = new InjectionState((SnippetInjectingResponseWrapper)wrapper);
            virtualField.set((Object)servletOutputStream, (Object)state);
        }
    }

    @Nullable
    public static InjectionState getInjectionState(ServletOutputStream servletOutputStream) {
        return (InjectionState)virtualField.get((Object)servletOutputStream);
    }

    private ServletOutputStreamInjectionState() {
    }
}

