/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet;

import io.opentelemetry.javaagent.bootstrap.servlet.SnippetInjectingResponseWrapper;
import io.opentelemetry.javaagent.instrumentation.servlet.snippet.SnippetInjectingPrintWriter;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.ServletOutputStreamInjectionState;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Servlet5SnippetInjectingResponseWrapper
extends HttpServletResponseWrapper
implements SnippetInjectingResponseWrapper {
    private static final Logger logger = Logger.getLogger(Servlet5SnippetInjectingResponseWrapper.class.getName());
    public static final String FAKE_SNIPPET_HEADER = "FAKE_SNIPPET_HEADER";
    private static final int UNSET = -1;
    private final String snippet;
    private final int snippetLength;
    private long contentLength = -1L;
    private SnippetInjectingPrintWriter snippetInjectingPrintWriter = null;

    public Servlet5SnippetInjectingResponseWrapper(HttpServletResponse response, String snippet) {
        super(response);
        this.snippet = snippet;
        this.snippetLength = snippet.length();
    }

    public boolean containsHeader(String name) {
        if (name.equals(FAKE_SNIPPET_HEADER)) {
            return true;
        }
        return super.containsHeader(name);
    }

    public void setHeader(String name, String value) {
        this.handleHeader(name, value);
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.handleHeader(name, value);
        super.addHeader(name, value);
    }

    private void handleHeader(String name, String value) {
        if ("Content-Length".equalsIgnoreCase(name) && this.isContentTypeTextHtml()) {
            try {
                this.contentLength = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                logger.log(Level.FINE, "Failed to parse the Content-Length header", ex);
            }
        }
    }

    public void setIntHeader(String name, int value) {
        if ("Content-Length".equalsIgnoreCase(name) && this.isContentTypeTextHtml()) {
            this.contentLength = value;
        }
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if ("Content-Length".equalsIgnoreCase(name) && this.isContentTypeTextHtml()) {
            this.contentLength = value;
        }
        super.addIntHeader(name, value);
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        super.setContentLength(len);
    }

    public void setContentLengthLong(long length) {
        this.contentLength = length;
        super.setContentLengthLong(length);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream output = super.getOutputStream();
        ServletOutputStreamInjectionState.initializeInjectionStateIfNeeded(output, this);
        return output;
    }

    public PrintWriter getWriter() throws IOException {
        if (!this.isContentTypeTextHtml()) {
            return super.getWriter();
        }
        if (this.snippetInjectingPrintWriter == null) {
            this.snippetInjectingPrintWriter = new SnippetInjectingPrintWriter(super.getWriter(), this.snippet, (SnippetInjectingResponseWrapper)this);
        }
        return this.snippetInjectingPrintWriter;
    }

    public boolean isContentTypeTextHtml() {
        String contentType = super.getContentType();
        if (contentType == null) {
            contentType = super.getHeader("content-type");
        }
        return contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("application/xhtml+xml"));
    }

    public void updateContentLengthIfPreviouslySet() {
        if (this.contentLength != -1L) {
            this.setContentLength((int)this.contentLength + this.snippetLength);
        }
    }

    public boolean isNotSafeToInject() {
        return this.contentLength != -1L && this.isCommitted();
    }
}

