/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseCustomizerHolder;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseMutator;
import io.opentelemetry.javaagent.bootstrap.servlet.AppServerBridge;
import io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class JakartaServletServiceAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnter(@Advice.This(typing=Assigner.Typing.DYNAMIC) Object servletOrFilter, @Advice.Argument(value=0, readOnly=false) ServletRequest request, @Advice.Argument(value=1, readOnly=false) ServletResponse response, @Advice.Local(value="otelCallDepth") CallDepth callDepth, @Advice.Local(value="otelRequest") ServletRequestContext<HttpServletRequest> requestContext, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
        Context contextToUpdate;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String snippet = Servlet5Singletons.getSnippetInjectionHelper().getSnippet();
        if (!snippet.isEmpty() && !((HttpServletResponse)response).containsHeader("FAKE_SNIPPET_HEADER")) {
            response = new Servlet5SnippetInjectingResponseWrapper((HttpServletResponse)response, snippet);
        }
        callDepth = CallDepth.forClass((Class)AppServerBridge.getCallDepthKey());
        callDepth.getAndIncrement();
        Context currentContext = Java8BytecodeBridge.currentContext();
        Context attachedContext = Servlet5Singletons.helper().getServerContext((Object)httpServletRequest);
        requestContext = new ServletRequestContext((Object)httpServletRequest, servletOrFilter);
        if (attachedContext == null && Servlet5Singletons.helper().shouldStart(currentContext, requestContext)) {
            context = Servlet5Singletons.helper().start(currentContext, requestContext);
            Servlet5Singletons.helper().setAsyncListenerResponse((Object)httpServletRequest, (Object)((HttpServletResponse)response));
            contextToUpdate = context;
        } else {
            contextToUpdate = attachedContext != null && Servlet5Singletons.helper().needsRescoping(currentContext, attachedContext) ? attachedContext : currentContext;
        }
        MappingResolver mappingResolver = Servlet5Singletons.getMappingResolver(servletOrFilter);
        boolean servlet = servletOrFilter instanceof Servlet;
        contextToUpdate = Servlet5Singletons.helper().updateContext(contextToUpdate, (Object)httpServletRequest, mappingResolver, servlet);
        scope = contextToUpdate.makeCurrent();
        if (context != null) {
            HttpServerResponseCustomizerHolder.getCustomizer().customize(contextToUpdate, (Object)((HttpServletResponse)response), (HttpServerResponseMutator)Servlet5Accessor.INSTANCE);
        }
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void stopSpan(@Advice.Argument(value=0) ServletRequest request, @Advice.Argument(value=1) ServletResponse response, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelCallDepth") CallDepth callDepth, @Advice.Local(value="otelRequest") ServletRequestContext<HttpServletRequest> requestContext, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        boolean topLevel = callDepth.decrementAndGet() == 0;
        Servlet5Singletons.helper().end(requestContext, (Object)((HttpServletRequest)request), (Object)((HttpServletResponse)response), throwable, topLevel, context, scope);
    }
}

