/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service;

import io.opentelemetry.javaagent.instrumentation.servlet.ServletFilterMappingResolverFactory;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Collection;

public class JakartaServletFilterMappingResolverFactory
extends ServletFilterMappingResolverFactory<FilterRegistration> {
    private final FilterConfig filterConfig;

    public JakartaServletFilterMappingResolverFactory(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected FilterRegistration getFilterRegistration() {
        String filterName = this.filterConfig.getFilterName();
        ServletContext servletContext = this.filterConfig.getServletContext();
        if (filterName == null || servletContext == null) {
            return null;
        }
        return servletContext.getFilterRegistration(filterName);
    }

    protected Collection<String> getUrlPatternMappings(FilterRegistration filterRegistration) {
        return filterRegistration.getUrlPatternMappings();
    }

    protected Collection<String> getServletNameMappings(FilterRegistration filterRegistration) {
        return filterRegistration.getServletNameMappings();
    }

    protected Collection<String> getServletMappings(String servletName) {
        ServletRegistration servletRegistration = this.filterConfig.getServletContext().getServletRegistration(servletName);
        if (servletRegistration == null) {
            return null;
        }
        return servletRegistration.getMappings();
    }
}

