/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.response;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.util.ClassAndMethod;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.instrumentation.servlet.common.response.HttpServletResponseAdviceHelper;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons;
import jakarta.servlet.http.HttpServletResponse;
import net.bytebuddy.asm.Advice;

public class ResponseSendAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void start(@Advice.This Object response, @Advice.Origin(value="#t") Class<?> declaringClass, @Advice.Origin(value="#m") String methodName, @Advice.Local(value="otelMethod") ClassAndMethod classAndMethod, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
        callDepth = CallDepth.forClass(HttpServletResponse.class);
        if (callDepth.getAndIncrement() > 0) {
            return;
        }
        HttpServletResponseAdviceHelper.StartResult result = HttpServletResponseAdviceHelper.startSpan(Servlet5Singletons.responseInstrumenter(), declaringClass, (String)methodName);
        if (result != null) {
            classAndMethod = result.getClassAndMethod();
            context = result.getContext();
            scope = result.getScope();
        }
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void stopSpan(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelMethod") ClassAndMethod classAndMethod, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
        if (callDepth.decrementAndGet() > 0) {
            return;
        }
        HttpServletResponseAdviceHelper.stopSpan(Servlet5Singletons.responseInstrumenter(), (Throwable)throwable, (Context)context, (Scope)scope, (ClassAndMethod)classAndMethod);
    }
}

