/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async;

import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletRequest;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class AsyncStartAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void startAsyncEnter(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
        callDepth = CallDepth.forClass(AsyncContext.class);
        callDepth.getAndIncrement();
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    public static void startAsyncExit(@Advice.This(typing=Assigner.Typing.DYNAMIC) HttpServletRequest request, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
        if (callDepth.decrementAndGet() != 0) {
            return;
        }
        if (request != null && !Servlet5Singletons.helper().isAsyncListenerAttached((Object)request)) {
            Servlet5Singletons.helper().attachAsyncListener((Object)request);
        }
    }
}

