/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletRequest;
import net.bytebuddy.asm.Advice;

public class AsyncDispatchAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void enter(@Advice.This AsyncContext context, @Advice.AllArguments Object[] args, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
        callDepth = CallDepth.forClass(AsyncContext.class);
        if (callDepth.getAndIncrement() > 0) {
            return;
        }
        ServletRequest request = context.getRequest();
        Context currentContext = Java8BytecodeBridge.currentContext();
        Span currentSpan = Java8BytecodeBridge.spanFromContext((Context)currentContext);
        if (currentSpan.getSpanContext().isValid()) {
            request.setAttribute(ServletHelper.CONTEXT_ATTRIBUTE, (Object)currentContext);
        }
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void exit(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
        callDepth.decrementAndGet();
    }
}

