/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0;

import io.opentelemetry.javaagent.bootstrap.servlet.InjectionState;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons;
import io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.ServletOutputStreamInjectionState;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.bytebuddy.asm.Advice;

public class Servlet5OutputStreamWriteIntAdvice {
    @Advice.OnMethodEnter(skipOn=Advice.OnDefaultValue.class, suppress=Throwable.class)
    public static boolean methodEnter(@Advice.This ServletOutputStream servletOutputStream, @Advice.Argument(value=0) int write) throws IOException {
        InjectionState state = ServletOutputStreamInjectionState.getInjectionState(servletOutputStream);
        if (state == null) {
            return true;
        }
        return !Servlet5Singletons.getSnippetInjectionHelper().handleWrite(state, (OutputStream)servletOutputStream, write);
    }
}

