/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0;

import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseMutator;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAsyncListener;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class Servlet5Accessor
implements ServletAccessor<HttpServletRequest, HttpServletResponse>,
HttpServerResponseMutator<HttpServletResponse> {
    public static final Servlet5Accessor INSTANCE = new Servlet5Accessor();

    private Servlet5Accessor() {
    }

    public String getRequestContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public String getRequestScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    public String getRequestUri(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String getRequestQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public Object getRequestAttribute(HttpServletRequest request, String name) {
        return request.getAttribute(name);
    }

    public void setRequestAttribute(HttpServletRequest request, String name, Object value) {
        request.setAttribute(name, value);
    }

    public String getRequestProtocol(HttpServletRequest request) {
        return request.getProtocol();
    }

    public String getRequestMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public String getRequestServerName(HttpServletRequest request) {
        return request.getServerName();
    }

    public Integer getRequestServerPort(HttpServletRequest request) {
        return request.getServerPort();
    }

    public String getRequestRemoteAddr(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    public Integer getRequestRemotePort(HttpServletRequest request) {
        return request.getRemotePort();
    }

    public String getRequestLocalAddr(HttpServletRequest request) {
        return request.getLocalAddr();
    }

    public Integer getRequestLocalPort(HttpServletRequest request) {
        return request.getLocalPort();
    }

    public String getRequestHeader(HttpServletRequest request, String name) {
        return request.getHeader(name);
    }

    public List<String> getRequestHeaderValues(HttpServletRequest request, String name) {
        Enumeration values = request.getHeaders(name);
        return values == null ? Collections.emptyList() : Collections.list(values);
    }

    public Iterable<String> getRequestHeaderNames(HttpServletRequest httpServletRequest) {
        return Collections.list(httpServletRequest.getHeaderNames());
    }

    public List<String> getRequestParameterValues(HttpServletRequest httpServletRequest, String name) {
        String[] values = httpServletRequest.getParameterValues(name);
        return values == null ? Collections.emptyList() : Arrays.asList(values);
    }

    public String getRequestServletPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    public String getRequestPathInfo(HttpServletRequest request) {
        return request.getPathInfo();
    }

    public Principal getRequestUserPrincipal(HttpServletRequest request) {
        return request.getUserPrincipal();
    }

    public void addRequestAsyncListener(HttpServletRequest request, ServletAsyncListener<HttpServletResponse> listener, Object response) {
        if (response instanceof HttpServletResponse) {
            request.getAsyncContext().addListener((AsyncListener)new Listener(listener), (ServletRequest)request, (ServletResponse)((HttpServletResponse)response));
        }
    }

    public int getResponseStatus(HttpServletResponse response) {
        return response.getStatus();
    }

    public List<String> getResponseHeaderValues(HttpServletResponse response, String name) {
        Collection values = response.getHeaders(name);
        if (values == null) {
            return Collections.emptyList();
        }
        if (values instanceof List) {
            return (List)values;
        }
        return new ArrayList<String>(values);
    }

    public boolean isResponseCommitted(HttpServletResponse response) {
        return response.isCommitted();
    }

    public boolean isServletException(Throwable throwable) {
        return throwable instanceof ServletException;
    }

    public void appendHeader(HttpServletResponse response, String name, String value) {
        response.addHeader(name, value);
    }

    private static class Listener
    implements AsyncListener {
        private final ServletAsyncListener<HttpServletResponse> listener;

        private Listener(ServletAsyncListener<HttpServletResponse> listener) {
            this.listener = listener;
        }

        public void onComplete(AsyncEvent event) {
            this.listener.onComplete((Object)((HttpServletResponse)event.getSuppliedResponse()));
        }

        public void onTimeout(AsyncEvent event) {
            this.listener.onTimeout(event.getAsyncContext().getTimeout());
        }

        public void onError(AsyncEvent event) {
            this.listener.onError(event.getThrowable(), (Object)((HttpServletResponse)event.getSuppliedResponse()));
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }
    }
}

