/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.v5_0;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.instrumentation.servlet.common.async.AsyncContextInstrumentation;
import io.opentelemetry.javaagent.instrumentation.servlet.common.async.AsyncContextStartInstrumentation;
import io.opentelemetry.javaagent.instrumentation.servlet.common.async.AsyncStartInstrumentation;
import io.opentelemetry.javaagent.instrumentation.servlet.common.response.HttpServletResponseInstrumentation;
import io.opentelemetry.javaagent.instrumentation.servlet.common.service.ServletAndFilterInstrumentation;
import io.opentelemetry.javaagent.instrumentation.servlet.common.service.ServletOutputStreamInstrumentation;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

@AutoService(value={InstrumentationModule.class})
public class JakartaServletInstrumentationModule
extends InstrumentationModule
implements InstrumentationModuleMuzzle {
    private static final String BASE_PACKAGE = "jakarta.servlet";

    public JakartaServletInstrumentationModule() {
        super("servlet", new String[]{"servlet-5.0"});
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        return Arrays.asList(new AsyncContextInstrumentation(BASE_PACKAGE, JakartaServletInstrumentationModule.adviceClassName(".async.AsyncDispatchAdvice")), new AsyncContextStartInstrumentation(BASE_PACKAGE, JakartaServletInstrumentationModule.adviceClassName(".async.AsyncContextStartAdvice")), new AsyncStartInstrumentation(BASE_PACKAGE, JakartaServletInstrumentationModule.adviceClassName(".async.AsyncStartAdvice")), new ServletAndFilterInstrumentation(BASE_PACKAGE, JakartaServletInstrumentationModule.adviceClassName(".service.JakartaServletServiceAdvice"), JakartaServletInstrumentationModule.adviceClassName(".service.JakartaServletInitAdvice"), JakartaServletInstrumentationModule.adviceClassName(".service.JakartaServletFilterInitAdvice")), new ServletOutputStreamInstrumentation(BASE_PACKAGE, JakartaServletInstrumentationModule.adviceClassName(".Servlet5OutputStreamWriteBytesAndOffsetAdvice"), JakartaServletInstrumentationModule.adviceClassName(".Servlet5OutputStreamWriteBytesAdvice"), JakartaServletInstrumentationModule.adviceClassName(".Servlet5OutputStreamWriteIntAdvice")), new HttpServletResponseInstrumentation(BASE_PACKAGE, JakartaServletInstrumentationModule.adviceClassName(".response.ResponseSendAdvice")));
    }

    private static String adviceClassName(String suffix) {
        return JakartaServletInstrumentationModule.class.getPackage().getName() + suffix;
    }

    public Map getMuzzleReferences() {
        HashMap<String, ClassRef> hashMap = new HashMap<String, ClassRef>(26, 0.75f);
        hashMap.put("jakarta.servlet.Filter", ClassRef.builder((String)"jakarta.servlet.Filter").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterInitAdvice", 23).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 72).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 39).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.FilterConfig", ClassRef.builder((String)"jakarta.servlet.FilterConfig").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterInitAdvice", 23).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 20).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 25).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 26).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 46).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 47).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 25)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getFilterName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 26), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 47)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletContext", Type.getType((String)"Ljakarta/servlet/ServletContext;"), new Type[0]).build());
        hashMap.put("jakarta.servlet.ServletContext", ClassRef.builder((String)"jakarta.servlet.ServletContext").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 26).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 30).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 47).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 25).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 30).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 30)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getFilterRegistration", Type.getType((String)"Ljakarta/servlet/FilterRegistration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 47), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 30)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletRegistration", Type.getType((String)"Ljakarta/servlet/ServletRegistration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("jakarta.servlet.FilterRegistration", ClassRef.builder((String)"jakarta.servlet.FilterRegistration").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 30).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 35).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 40).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 15).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 35)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getUrlPatternMappings", Type.getType((String)"Ljava/util/Collection;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 40)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletNameMappings", Type.getType((String)"Ljava/util/Collection;"), new Type[0]).build());
        hashMap.put("jakarta.servlet.ServletRegistration", ClassRef.builder((String)"jakarta.servlet.ServletRegistration").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 47).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 51).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 30).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 34).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory", 51), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 34)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMappings", Type.getType((String)"Ljava/util/Collection;"), new Type[0]).build());
        hashMap.put("jakarta.servlet.http.HttpServletResponse", ClassRef.builder((String)"jakarta.servlet.http.HttpServletResponse").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.response.ResponseSendAdvice", 30).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 144).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 146).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 153).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 158).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 170).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 180).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 24).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 43).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 49).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 51).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 52).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 66).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 92).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 107).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 113).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 47).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 153)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatus", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 158)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/util/Collection;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 170)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isCommitted", Type.getType((String)"Z"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 180)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 51)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "containsHeader", Type.getType((String)"Z"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("jakarta.servlet.Servlet", ClassRef.builder((String)"jakarta.servlet.Servlet").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 68).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 70).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 37).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 85).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletInitAdvice", 23).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.http.HttpServletRequest", ClassRef.builder((String)"jakarta.servlet.http.HttpServletRequest").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 33).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 38).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 43).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 53).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 58).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 63).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 68).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 73).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 78).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 83).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 88).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 93).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 98).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 103).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 108).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 114).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 120).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 126).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 131).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 146).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 24).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 43).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 46).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 107).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 113).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncContextStartAdvice", 23).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncContextStartAdvice", 24).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 33)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getContextPath", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 38)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getScheme", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 43)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRequestURI", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 48)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getQueryString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 53)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAttribute", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 58)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setAttribute", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 63)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getProtocol", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 68)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMethod", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 73)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServerName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 78)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServerPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 83)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemoteAddr", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 88)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemotePort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 93)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalAddr", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 98)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 103)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 108)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/util/Enumeration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 114)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaderNames", Type.getType((String)"Ljava/util/Enumeration;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 120)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getParameterValues", Type.getType((String)"[Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 126)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletPath", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 131)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getPathInfo", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getUserPrincipal", Type.getType((String)"Ljava/security/Principal;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 146)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAsyncContext", Type.getType((String)"Ljakarta/servlet/AsyncContext;"), new Type[0]).build());
        hashMap.put("jakarta.servlet.AsyncContext", ClassRef.builder((String)"jakarta.servlet.AsyncContext").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 146).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 147).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 197).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 207).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncDispatchAdvice", 26).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncDispatchAdvice", 31).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncStartAdvice", 22).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncContextStartAdvice", 22).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 147)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addListener", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncListener;"), Type.getType((String)"Ljakarta/servlet/ServletRequest;"), Type.getType((String)"Ljakarta/servlet/ServletResponse;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 197)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getTimeout", Type.getType((String)"J"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 207)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addListener", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncListener;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncDispatchAdvice", 31), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncContextStartAdvice", 22)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRequest", Type.getType((String)"Ljakarta/servlet/ServletRequest;"), new Type[0]).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 146).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 197).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 183).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("java.lang.Object").addInterfaceName("jakarta.servlet.AsyncListener").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 197), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "listener", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/servlet/ServletAsyncListener;"), true).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onComplete", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onTimeout", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onError", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onStartAsync", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).build());
        hashMap.put("jakarta.servlet.AsyncListener", ClassRef.builder((String)"jakarta.servlet.AsyncListener").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 147).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 207).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.ServletRequest", ClassRef.builder((String)"jakarta.servlet.ServletRequest").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 147).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncDispatchAdvice", 31).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncDispatchAdvice", 43).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncContextStartAdvice", 22).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.async.AsyncDispatchAdvice", 43)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setAttribute", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/Object;")}).build());
        hashMap.put("jakarta.servlet.ServletResponse", ClassRef.builder((String)"jakarta.servlet.ServletResponse").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 147).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.ServletException", ClassRef.builder((String)"jakarta.servlet.ServletException").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 175).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.AsyncEvent", ClassRef.builder((String)"jakarta.servlet.AsyncEvent").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 197).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 207).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getSuppliedResponse", Type.getType((String)"Ljakarta/servlet/ServletResponse;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 197), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 207)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAsyncContext", Type.getType((String)"Ljakarta/servlet/AsyncContext;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 202)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getThrowable", Type.getType((String)"Ljava/lang/Throwable;"), new Type[0]).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletServiceAdvice", 52).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 42).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 44).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 49).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 69).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 75).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 81).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 83).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 85).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 93).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 94).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 102).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 103).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 110).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 116).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 123).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 129).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 132).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 134).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 136).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 151).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 152).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 161).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 33).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 34).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.ServletOutputStreamInjectionState", 20).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).setSuperClassName("jakarta.servlet.http.HttpServletResponseWrapper").addInterfaceName("io.opentelemetry.javaagent.bootstrap.servlet.SnippetInjectingResponseWrapper").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 85), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 34)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "logger", Type.getType((String)"Ljava/util/logging/Logger;"), true).addField(new Source[0], new Flag[0], "FAKE_SNIPPET_HEADER", Type.getType((String)"Ljava/lang/String;"), true).addField(new Source[0], new Flag[0], "UNSET", Type.getType((String)"I"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 48), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 134)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "snippet", Type.getType((String)"Ljava/lang/String;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 49), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 152)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "snippetLength", Type.getType((String)"I"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 42), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 83), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 94), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 103), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 110), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 116), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 151), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 152), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 161)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "contentLength", Type.getType((String)"J"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 44), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 132), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 134), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 136)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "snippetInjectingPrintWriter", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/servlet/snippet/SnippetInjectingPrintWriter;"), true).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "containsHeader", Type.getType((String)"Z"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "setHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 81), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 93), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 102), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 129), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.ServletOutputStreamInjectionState", 20)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.VisibilityFlag.PUBLIC, Flag.ManifestationFlag.NON_FINAL, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isContentTypeTextHtml", Type.getType((String)"Z"), new Type[0]).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "setIntHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"I")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "addIntHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 152)}, new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "setContentLength", Type.getType((String)"V"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "setContentLengthLong", Type.getType((String)"V"), new Type[]{Type.getType((String)"J")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "getOutputStream", Type.getType((String)"Ljakarta/servlet/ServletOutputStream;"), new Type[0]).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "getWriter", Type.getType((String)"Ljava/io/PrintWriter;"), new Type[0]).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "updateContentLengthIfPreviouslySet", Type.getType((String)"V"), new Type[0]).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "isNotSafeToInject", Type.getType((String)"Z"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 161)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "isCommitted", Type.getType((String)"Z"), new Type[0]).build());
        hashMap.put("jakarta.servlet.http.HttpServletResponseWrapper", ClassRef.builder((String)"jakarta.servlet.http.HttpServletResponseWrapper").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 47).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 64).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 70).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 76).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 96).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 105).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 111).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 117).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 122).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 130).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 134).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 141).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 143).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 47)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/http/HttpServletResponse;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 64)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "containsHeader", Type.getType((String)"Z"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 70)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 76)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 96)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setIntHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 105)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addIntHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 111)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setContentLength", Type.getType((String)"V"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 117)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setContentLengthLong", Type.getType((String)"V"), new Type[]{Type.getType((String)"J")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 122)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getOutputStream", Type.getType((String)"Ljakarta/servlet/ServletOutputStream;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 130), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 134)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getWriter", Type.getType((String)"Ljava/io/PrintWriter;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 141)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getContentType", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 143)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("jakarta.servlet.ServletOutputStream", ClassRef.builder((String)"jakarta.servlet.ServletOutputStream").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 122).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper", 123).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.ServletOutputStreamInjectionState", 14).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5OutputStreamWriteIntAdvice", 22).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5OutputStreamWriteBytesAndOffsetAdvice", 24).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5OutputStreamWriteBytesAdvice", 22).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.ServletConfig", ClassRef.builder((String)"jakarta.servlet.ServletConfig").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletInitAdvice", 23).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 18).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 24).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 25).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 24)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory", 25)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletContext", Type.getType((String)"Ljakarta/servlet/ServletContext;"), new Type[0]).build());
        return hashMap;
    }

    public List getMuzzleHelperClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(33);
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletMappingResolverFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletMappingResolverFactory$Mappings");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletMappingResolverFactory$MappingResolverHolder");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.common.response.HttpServletResponseAdviceHelper$StartResult");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.common.response.HttpServletResponseAdviceHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.snippet.OutputStreamSnippetInjectionHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletInstrumenterBuilder");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.common.response.ResponseInstrumenterFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.common.response.HttpServletResponseAdviceHelper$1");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.BaseServletHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAsyncListener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.AsyncRunnableWrapper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAdditionalAttributesExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletErrorCauseExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestParametersExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletHttpAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$1");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletSpanNameProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.Servlet5SnippetInjectingResponseWrapper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.snippet.SnippetInjectingPrintWriter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.snippet.ServletOutputStreamInjectionState");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletFilterMappingResolverFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletMappingResolverFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.AsyncRequestCompletionListener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.service.JakartaServletFilterMappingResolverFactory");
        return arrayList;
    }

    public void registerMuzzleVirtualFields(VirtualFieldMappingsBuilder virtualFieldMappingsBuilder) {
        virtualFieldMappingsBuilder.register("jakarta.servlet.Servlet", "io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver$Factory").register("jakarta.servlet.Filter", "io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver$Factory").register("jakarta.servlet.ServletOutputStream", "io.opentelemetry.javaagent.bootstrap.servlet.InjectionState");
    }
}

