/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.restlet.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteSource;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseCustomizerHolder;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseMutator;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.restlet.v2_0.RestletResponseMutator;
import io.opentelemetry.javaagent.instrumentation.restlet.v2_0.RestletSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;

public class ServerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.restlet.Server");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"handle")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.restlet.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.restlet.Response"))), this.getClass().getName() + "$ServerHandleAdvice");
    }

    public static class ServerHandleAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void beginRequest(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) Response response, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!RestletSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = RestletSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void finishRequest(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) Response response, @Advice.Thrown Throwable exception, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (Status.CLIENT_ERROR_NOT_FOUND.equals((Object)response.getStatus())) {
                HttpServerRoute.update((Context)context, (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, RestletSingletons.serverSpanName(), (Object)"/*");
            }
            HttpServerResponseCustomizerHolder.getCustomizer().customize(context, (Object)response, (HttpServerResponseMutator)RestletResponseMutator.INSTANCE);
            if (exception != null) {
                RestletSingletons.instrumenter().end(context, (Object)request, (Object)response, exception);
                return;
            }
            Throwable statusThrowable = response.getStatus().getThrowable();
            RestletSingletons.instrumenter().end(context, (Object)request, (Object)response, statusThrowable);
        }
    }
}

