/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.restlet.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteSource;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.restlet.v2_0.RestletSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.restlet.Request;
import org.restlet.routing.TemplateRoute;

public class RouteInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.namedOneOf((String[])new String[]{"org.restlet.routing.TemplateRoute", "org.restlet.routing.Route"});
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"beforeHandle")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.restlet.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.restlet.Response"))), this.getClass().getName() + "$RouteBeforeHandleAdvice");
    }

    public static class RouteBeforeHandleAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void getRouteInfo(@Advice.This TemplateRoute route, @Advice.Argument(value=0) Request request) {
            String pattern = route.getTemplate().getPattern();
            HttpServerRoute.update((Context)Java8BytecodeBridge.currentContext(), (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, RestletSingletons.serverSpanName(), (Object)pattern);
        }
    }
}

