/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.ratpack;

import io.netty.util.Attribute;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.ServerContext;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.ratpack.RatpackSingletons;
import java.util.Deque;
import ratpack.handling.Handler;

public final class TracingHandler
implements Handler {
    private static final String INITIAL_SPAN_NAME = "ratpack.handler";
    public static final Handler INSTANCE = new TracingHandler();

    public void handle(ratpack.handling.Context ctx) {
        Context callbackContext;
        Context parentOtelContext;
        Attribute serverContextAttribute = ctx.getDirectChannelAccess().getChannel().attr(AttributeKeys.SERVER_CONTEXT);
        Deque serverContexts = (Deque)serverContextAttribute.get();
        ServerContext serverContext = serverContexts != null ? (ServerContext)serverContexts.peekFirst() : null;
        Context context = parentOtelContext = serverContext != null ? serverContext.context() : Java8BytecodeBridge.currentContext();
        if (RatpackSingletons.instrumenter().shouldStart(parentOtelContext, (Object)INITIAL_SPAN_NAME)) {
            Context otelContext = RatpackSingletons.instrumenter().start(parentOtelContext, (Object)INITIAL_SPAN_NAME);
            ctx.getExecution().add((Object)otelContext);
            ctx.getResponse().beforeSend(response -> {
                RatpackSingletons.updateSpanNames(otelContext, ctx);
                RatpackSingletons.instrumenter().end(otelContext, (Object)INITIAL_SPAN_NAME, null, null);
            });
            callbackContext = otelContext;
        } else {
            ctx.getResponse().beforeSend(response -> RatpackSingletons.updateServerSpanName(parentOtelContext, ctx));
            callbackContext = parentOtelContext;
        }
        try (Scope ignored = callbackContext.makeCurrent();){
            ctx.next();
        }
    }
}

