/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.ratpack;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteSource;

public final class RatpackSingletons {
    private static final Instrumenter<String, Void> INSTRUMENTER = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.opentelemetry.ratpack-1.4", s -> s).buildInstrumenter();

    public static Instrumenter<String, Void> instrumenter() {
        return INSTRUMENTER;
    }

    public static void updateSpanNames(Context otelContext, ratpack.handling.Context ctx) {
        String matchedRoute = RatpackSingletons.updateServerSpanName(otelContext, ctx);
        Span.fromContext((Context)otelContext).updateName(matchedRoute);
    }

    public static String updateServerSpanName(Context otelContext, ratpack.handling.Context ctx) {
        String matchedRoute = ctx.getPathBinding().getDescription();
        if (matchedRoute == null || matchedRoute.isEmpty()) {
            matchedRoute = "/";
        } else if (!matchedRoute.startsWith("/")) {
            matchedRoute = "/" + matchedRoute;
        }
        HttpServerRoute.update((Context)otelContext, (HttpServerRouteSource)HttpServerRouteSource.SERVER_FILTER, (String)matchedRoute);
        return matchedRoute;
    }

    public static void onError(Context context, Throwable error) {
        Span span = Span.fromContext((Context)context);
        span.setStatus(StatusCode.ERROR);
        span.recordException(ErrorCauseExtractor.getDefault().extract(error));
    }

    private RatpackSingletons() {
    }
}

