/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.ratpack;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import ratpack.func.Block;

public class BlockWrapper
implements Block {
    private final Block delegate;
    private final Context parentContext;

    private BlockWrapper(Block delegate, Context parentContext) {
        assert (parentContext != null);
        this.delegate = delegate;
        this.parentContext = parentContext;
    }

    public void execute() throws Exception {
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.delegate.execute();
        }
    }

    public static Block wrapIfNeeded(Block delegate) {
        if (delegate instanceof BlockWrapper) {
            return delegate;
        }
        Context context = Context.current();
        if (context == Context.root()) {
            return delegate;
        }
        return new BlockWrapper(delegate, context);
    }
}

