/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.ratpack;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import ratpack.func.Action;

public class ActionWrapper<T>
implements Action<T> {
    private final Action<T> delegate;
    private final Context parentContext;

    private ActionWrapper(Action<T> delegate, Context parentContext) {
        assert (parentContext != null);
        this.delegate = delegate;
        this.parentContext = parentContext;
    }

    public void execute(T t) throws Exception {
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.delegate.execute(t);
        }
    }

    public static <T> Action<T> wrapIfNeeded(Action<T> delegate) {
        if (delegate instanceof ActionWrapper) {
            return delegate;
        }
        Context context = Context.current();
        if (context == Context.root()) {
            return delegate;
        }
        return new ActionWrapper<T>(delegate, context);
    }
}

