/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.playws.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.instrumentation.playws.v2_0.PlayWs20Singletons;
import java.net.InetSocketAddress;
import java.util.List;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequest;

public class AsyncHandlerWrapper<T>
implements AsyncHandler<T> {
    private final AsyncHandler<T> delegate;
    private final Request request;
    private final Context context;
    private final Context parentContext;
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();

    public AsyncHandlerWrapper(AsyncHandler<T> delegate, Request request, Context context, Context parentContext) {
        this.delegate = delegate;
        this.request = request;
        this.context = context;
        this.parentContext = parentContext;
    }

    public Context getParentContext() {
        return this.parentContext;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.builder.accumulate(content);
        return this.delegate.onBodyPartReceived(content);
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.builder.reset();
        this.builder.accumulate(status);
        return this.delegate.onStatusReceived(status);
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders httpHeaders) throws Exception {
        this.builder.accumulate(httpHeaders);
        return this.delegate.onHeadersReceived(httpHeaders);
    }

    public T onCompleted() throws Exception {
        Response response = this.builder.build();
        PlayWs20Singletons.instrumenter().end(this.context, (Object)this.request, (Object)response, null);
        try (Scope ignored = this.parentContext.makeCurrent();){
            Object object = this.delegate.onCompleted();
            return (T)object;
        }
    }

    public void onThrowable(Throwable throwable) {
        PlayWs20Singletons.instrumenter().end(this.context, (Object)this.request, null, throwable);
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.delegate.onThrowable(throwable);
        }
    }

    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        return this.delegate.onTrailingHeadersReceived(headers);
    }

    public void onHostnameResolutionAttempt(String name) {
        this.delegate.onHostnameResolutionAttempt(name);
    }

    public void onHostnameResolutionSuccess(String name, List<InetSocketAddress> list) {
        this.delegate.onHostnameResolutionSuccess(name, list);
    }

    public void onHostnameResolutionFailure(String name, Throwable cause) {
        this.delegate.onHostnameResolutionFailure(name, cause);
    }

    public void onTcpConnectAttempt(InetSocketAddress remoteAddress) {
        this.delegate.onTcpConnectAttempt(remoteAddress);
    }

    public void onTcpConnectSuccess(InetSocketAddress remoteAddress, Channel connection) {
        this.delegate.onTcpConnectSuccess(remoteAddress, connection);
    }

    public void onTcpConnectFailure(InetSocketAddress remoteAddress, Throwable cause) {
        this.delegate.onTcpConnectFailure(remoteAddress, cause);
    }

    public void onTlsHandshakeAttempt() {
        this.delegate.onTlsHandshakeAttempt();
    }

    public void onTlsHandshakeSuccess() {
        this.delegate.onTlsHandshakeSuccess();
    }

    public void onTlsHandshakeFailure(Throwable cause) {
        this.delegate.onTlsHandshakeFailure(cause);
    }

    public void onConnectionPoolAttempt() {
        this.delegate.onConnectionPoolAttempt();
    }

    public void onConnectionPooled(Channel connection) {
        this.delegate.onConnectionPooled(connection);
    }

    public void onConnectionOffer(Channel connection) {
        this.delegate.onConnectionOffer(connection);
    }

    public void onRequestSend(NettyRequest request) {
        this.delegate.onRequestSend(request);
    }

    public void onRetry() {
        this.delegate.onRetry();
    }
}

