/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.opensearch.rest.v1_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.opensearch.rest.OpenSearchRestRequest;
import io.opentelemetry.javaagent.instrumentation.opensearch.rest.RestResponseListener;
import io.opentelemetry.javaagent.instrumentation.opensearch.rest.v1_0.OpenSearchRestSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseListener;

public class RestClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.opensearch.client.RestClient");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"performRequest")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.opensearch.client.Request"))), this.getClass().getName() + "$PerformRequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"performRequestAsync")).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.opensearch.client.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.opensearch.client.ResponseListener"))), this.getClass().getName() + "$PerformRequestAsyncAdvice");
    }

    public static class PerformRequestAsyncAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1, readOnly=false) ResponseListener responseListener, @Advice.Local(value="otelRequest") OpenSearchRestRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            otelRequest = OpenSearchRestRequest.create((String)request.getMethod(), (String)request.getEndpoint());
            if (!OpenSearchRestSingletons.instrumenter().shouldStart(parentContext, (Object)otelRequest)) {
                return;
            }
            context = OpenSearchRestSingletons.instrumenter().start(parentContext, (Object)otelRequest);
            scope = context.makeCurrent();
            responseListener = new RestResponseListener(responseListener, parentContext, OpenSearchRestSingletons.instrumenter(), context, otelRequest);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") OpenSearchRestRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable != null) {
                OpenSearchRestSingletons.instrumenter().end(context, (Object)otelRequest, null, throwable);
            }
        }
    }

    public static class PerformRequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) Request request, @Advice.Local(value="otelRequest") OpenSearchRestRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            otelRequest = OpenSearchRestRequest.create((String)request.getMethod(), (String)request.getEndpoint());
            if (!OpenSearchRestSingletons.instrumenter().shouldStart(parentContext, (Object)otelRequest)) {
                return;
            }
            context = OpenSearchRestSingletons.instrumenter().start(parentContext, (Object)otelRequest);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Return Response response, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelRequest") OpenSearchRestRequest otelRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            OpenSearchRestSingletons.instrumenter().end(context, (Object)otelRequest, (Object)response, throwable);
        }
    }
}

