/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.lettuce.v4_0;

import com.lambdaworks.redis.RedisURI;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class LettuceConnectInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"com.lambdaworks.redis.RedisClient");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"connectStandalone")), LettuceConnectInstrumentation.class.getName() + "$ConnectAdvice");
    }

    public static class ConnectAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=1) RedisURI redisUri, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            context = LettuceSingletons.connectInstrumenter().start(Java8BytecodeBridge.currentContext(), (Object)redisUri);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Argument(value=1) RedisURI redisUri, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            scope.close();
            LettuceSingletons.connectInstrumenter().end(context, (Object)redisUri, null, throwable);
        }
    }
}

