/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.lettuce.v4_0;

import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.InstrumentationPoints;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class LettuceAsyncCommandsInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"com.lambdaworks.redis.AbstractRedisAsyncCommands");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"dispatch")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"com.lambdaworks.redis.protocol.RedisCommand"))), LettuceAsyncCommandsInstrumentation.class.getName() + "$DispatchAdvice");
    }

    public static class DispatchAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) RedisCommand<?, ?, ?> command, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            context = LettuceSingletons.instrumenter().start(parentContext, command);
            context = context.with(LettuceSingletons.COMMAND_CONTEXT_KEY, (Object)parentContext);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Argument(value=0) RedisCommand<?, ?, ?> command, @Advice.Thrown Throwable throwable, @Advice.Return AsyncCommand<?, ?, ?> asyncCommand, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            scope.close();
            InstrumentationPoints.afterCommand(command, context, throwable, asyncCommand);
        }
    }
}

