/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.lettuce.v4_0;

import com.lambdaworks.redis.protocol.AsyncCommand;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceSingletons;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class LettuceAsyncCommandInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"com.lambdaworks.redis.protocol.AsyncCommand");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isConstructor(), LettuceAsyncCommandInstrumentation.class.getName() + "$SaveContextAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"complete").or((ElementMatcher)ElementMatchers.named((String)"completeExceptionally")).or((ElementMatcher)ElementMatchers.named((String)"cancel")), LettuceAsyncCommandInstrumentation.class.getName() + "$RestoreContextAdvice");
    }

    public static class RestoreContextAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.This AsyncCommand<?, ?, ?> asyncCommand, @Advice.Local(value="otelScope") Scope scope) {
            Context context = (Context)VirtualField.find(AsyncCommand.class, Context.class).get(asyncCommand);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Local(value="otelScope") Scope scope) {
            scope.close();
        }
    }

    public static class SaveContextAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void saveContext(@Advice.This AsyncCommand<?, ?, ?> asyncCommand) {
            Context context = Java8BytecodeBridge.currentContext();
            context = (Context)context.get(LettuceSingletons.COMMAND_CONTEXT_KEY);
            VirtualField.find(AsyncCommand.class, Context.class).set(asyncCommand, (Object)context);
        }
    }
}

