/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.lettuce.v4_0;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceConnectAttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceConnectNetworkAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceDbAttributesGetter;
import java.util.Map;

public final class LettuceSingletons {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.lettuce-4.0";
    private static final Instrumenter<RedisCommand<?, ?, ?>, Void> INSTRUMENTER;
    private static final Instrumenter<RedisURI, Void> CONNECT_INSTRUMENTER;
    public static final ContextKey<Context> COMMAND_CONTEXT_KEY;

    public static Instrumenter<RedisCommand<?, ?, ?>, Void> instrumenter() {
        return INSTRUMENTER;
    }

    public static Instrumenter<RedisURI, Void> connectInstrumenter() {
        return CONNECT_INSTRUMENTER;
    }

    private LettuceSingletons() {
    }

    static {
        COMMAND_CONTEXT_KEY = ContextKey.named((String)"opentelemetry-lettuce-v4_0-context-key");
        LettuceDbAttributesGetter dbAttributesGetter = new LettuceDbAttributesGetter();
        INSTRUMENTER = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)DbClientSpanNameExtractor.create((DbClientAttributesGetter)dbAttributesGetter)).addAttributesExtractor(DbClientAttributesExtractor.create((DbClientAttributesGetter)dbAttributesGetter)).buildInstrumenter(SpanKindExtractor.alwaysClient());
        LettuceConnectNetworkAttributesGetter netAttributesGetter = new LettuceConnectNetworkAttributesGetter();
        CONNECT_INSTRUMENTER = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)INSTRUMENTATION_NAME, redisUri -> "CONNECT").addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)netAttributesGetter)).addAttributesExtractor(PeerServiceAttributesExtractor.create((ServerAttributesGetter)netAttributesGetter, (Map)CommonConfig.get().getPeerServiceMapping())).addAttributesExtractor((AttributesExtractor)new LettuceConnectAttributesExtractor()).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

