/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.lettuce.v4_0;

import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.instrumentation.lettuce.v4_0.LettuceSingletons;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CancellationException;

public final class InstrumentationPoints {
    private static final boolean CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES = InstrumentationConfig.get().getBoolean("otel.instrumentation.lettuce.experimental-span-attributes", false);
    private static final Set<CommandType> NON_INSTRUMENTING_COMMANDS = EnumSet.of(CommandType.SHUTDOWN, CommandType.DEBUG);

    public static void afterCommand(RedisCommand<?, ?, ?> command, Context context, Throwable throwable, AsyncCommand<?, ?, ?> asyncCommand) {
        if (throwable != null) {
            LettuceSingletons.instrumenter().end(context, command, null, throwable);
        } else if (InstrumentationPoints.expectsResponse(command)) {
            asyncCommand.handleAsync((value, ex) -> {
                if (ex instanceof CancellationException) {
                    if (CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES) {
                        Span span = Span.fromContext((Context)context);
                        span.setAttribute("lettuce.command.cancelled", true);
                    }
                    ex = null;
                }
                LettuceSingletons.instrumenter().end(context, (Object)command, null, ex);
                return null;
            });
        } else {
            LettuceSingletons.instrumenter().end(context, command, null, null);
        }
    }

    public static boolean expectsResponse(RedisCommand<?, ?, ?> command) {
        ProtocolKeyword keyword = command.getType();
        return !InstrumentationPoints.isNonInstrumentingCommand(keyword) && !InstrumentationPoints.isNonInstrumentingKeyword(keyword);
    }

    private static boolean isNonInstrumentingCommand(ProtocolKeyword keyword) {
        return keyword instanceof CommandType && NON_INSTRUMENTING_COMMANDS.contains(keyword);
    }

    private static boolean isNonInstrumentingKeyword(ProtocolKeyword keyword) {
        return keyword == CommandKeyword.SEGFAULT;
    }

    private InstrumentationPoints() {
    }
}

