/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpurlconnection;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class HttpUrlHttpAttributesGetter
implements HttpClientAttributesGetter<HttpURLConnection, Integer> {
    HttpUrlHttpAttributesGetter() {
    }

    public String getHttpRequestMethod(HttpURLConnection connection) {
        return connection.getRequestMethod();
    }

    public String getUrlFull(HttpURLConnection connection) {
        return connection.getURL().toExternalForm();
    }

    public List<String> getHttpRequestHeader(HttpURLConnection connection, String name) {
        String value = connection.getRequestProperty(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    public Integer getHttpResponseStatusCode(HttpURLConnection connection, Integer statusCode, @Nullable Throwable error) {
        return statusCode;
    }

    public List<String> getHttpResponseHeader(HttpURLConnection connection, Integer statusCode, String name) {
        String value = connection.getHeaderField(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Nullable
    public String getNetworkProtocolName(HttpURLConnection connection, @Nullable Integer integer) {
        return "http";
    }

    @Nullable
    public String getNetworkProtocolVersion(HttpURLConnection connection, @Nullable Integer integer) {
        return "1.1";
    }

    public String getServerAddress(HttpURLConnection connection) {
        return connection.getURL().getHost();
    }

    public Integer getServerPort(HttpURLConnection connection) {
        return connection.getURL().getPort();
    }
}

